/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.PopupMenuHandler;
import docking.action.DockingActionIf;
import docking.action.DockingActionProviderIf;
import docking.action.MenuData;
import docking.menu.MenuGroupMap;
import docking.menu.MenuManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;

public class PopupActionManager
implements PropertyChangeListener {
    private List<DockingActionIf> popupActions = new ArrayList<DockingActionIf>();
    private DockingWindowManager windowManager;
    private MenuGroupMap menuGroupMap;

    public PopupActionManager(DockingWindowManager windowManager, MenuGroupMap menuGroupMap) {
        this.windowManager = windowManager;
        this.menuGroupMap = menuGroupMap;
    }

    public void addAction(DockingActionIf action) {
        action.addPropertyChangeListener(this);
        if (action.getPopupMenuData() != null) {
            this.popupActions.add(action);
        }
    }

    public void removeAction(DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.popupActions.remove(action);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("PopupMenu".equals(propertyName)) {
            MenuData newData;
            MenuData oldData = (MenuData)evt.getOldValue();
            if (this.isAddingToPopup(oldData, newData = (MenuData)evt.getNewValue())) {
                this.popupActions.add((DockingActionIf)evt.getSource());
            }
            if (this.isRemovingFromPopup(oldData, newData)) {
                this.popupActions.remove(evt.getSource());
            }
        }
    }

    void popupMenu(ComponentPlaceholder info, MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        ComponentProvider popupProvider = info.getProvider();
        ActionContext actionContext = popupProvider.getActionContext(e);
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        actionContext.setSource(e.getSource());
        actionContext.setMouseEvent(e);
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.windowManager, actionContext);
        MenuManager menuMgr = new MenuManager("Popup", '\u0000', null, true, popupMenuHandler, this.menuGroupMap);
        this.populatePopupMenuActions(info, actionContext, menuMgr);
        if (menuMgr.isEmpty()) {
            return;
        }
        JPopupMenu popupMenu = menuMgr.getPopupMenu();
        Component c = (Component)e.getSource();
        popupMenu.addPopupMenuListener(popupMenuHandler);
        popupMenu.show(c, e.getX(), e.getY());
    }

    private void populatePopupMenuActions(ComponentPlaceholder info, ActionContext actionContext, MenuManager menuMgr) {
        MenuData popupMenuData;
        List<DockingActionIf> tempActions;
        Object source = actionContext.getSourceObject();
        if (source instanceof DockingActionProviderIf) {
            DockingActionProviderIf actionProvider = (DockingActionProviderIf)source;
            List<DockingActionIf> dockingActions = actionProvider.getDockingActions(actionContext);
            Iterator<DockingActionIf> iterator = dockingActions.iterator();
            while (iterator.hasNext()) {
                DockingActionIf action = iterator.next();
                MenuData popupMenuData2 = action.getPopupMenuData();
                if (popupMenuData2 == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
                action.setEnabled(action.isEnabledForContext(actionContext));
                menuMgr.addAction(action);
            }
        }
        if ((tempActions = this.windowManager.getTemporaryPopupActions(actionContext)) != null) {
            for (DockingActionIf action : tempActions) {
                popupMenuData = action.getPopupMenuData();
                if (popupMenuData == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
                action.setEnabled(action.isEnabledForContext(actionContext));
                menuMgr.addAction(action);
            }
        }
        for (DockingActionIf action : this.popupActions) {
            popupMenuData = action.getPopupMenuData();
            if (popupMenuData == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
            boolean isEnabled = action.isEnabledForContext(actionContext);
            action.setEnabled(isEnabled);
            menuMgr.addAction(action);
        }
        Iterator<DockingActionIf> iter = info.getActions();
        while (iter.hasNext()) {
            DockingActionIf action;
            action = iter.next();
            if (action.getPopupMenuData() == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
            action.setEnabled(action.isEnabledForContext(actionContext));
            menuMgr.addAction(action);
        }
    }

    private boolean isRemovingFromPopup(MenuData oldData, MenuData newData) {
        return oldData != null && newData == null;
    }

    private boolean isAddingToPopup(MenuData oldData, MenuData newData) {
        return oldData == null && newData != null;
    }

    public void dispose() {
        this.popupActions.clear();
        this.windowManager = null;
    }
}

