/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.DockingUtils;
import docking.KeyBindingPrecedence;
import javax.swing.KeyStroke;

public class KeyBindingData {
    private KeyStroke keyStroke;
    private KeyBindingPrecedence keyBindingPrecedence;

    public KeyBindingData(KeyStroke keyStroke) {
        this(keyStroke, KeyBindingPrecedence.DefaultLevel);
    }

    public KeyBindingData(char c, int modifiers) {
        this((int)Character.toUpperCase(c), modifiers);
    }

    public KeyBindingData(int keyCode, int modifiers) {
        this(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public KeyBindingData(KeyStroke keyStroke, KeyBindingPrecedence precedence) {
        if (precedence == KeyBindingPrecedence.ReservedActionsLevel) {
            throw new IllegalArgumentException("Can't set precedence to Reserved KeyBindingPrecedence");
        }
        this.keyStroke = keyStroke;
        this.keyBindingPrecedence = precedence;
    }

    public KeyStroke getKeyBinding() {
        return this.keyStroke;
    }

    public KeyBindingPrecedence getKeyBindingPrecedence() {
        return this.keyBindingPrecedence;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[KeyStroke=" + this.keyStroke + ", precedence=" + this.keyBindingPrecedence + "]";
    }

    static KeyBindingData createReservedKeyBindingData(KeyStroke keyStroke) {
        KeyBindingData keyBindingData = new KeyBindingData(keyStroke);
        keyBindingData.keyBindingPrecedence = KeyBindingPrecedence.ReservedActionsLevel;
        return keyBindingData;
    }

    public static KeyBindingData validateKeyBindingData(KeyBindingData newKeyBindingData) {
        KeyStroke keyBinding = newKeyBindingData.getKeyBinding();
        if (keyBinding == null) {
            return newKeyBindingData;
        }
        KeyBindingPrecedence precedence = newKeyBindingData.getKeyBindingPrecedence();
        if (precedence == KeyBindingPrecedence.ReservedActionsLevel) {
            return KeyBindingData.createReservedKeyBindingData(KeyBindingData.validateKeyStroke(keyBinding));
        }
        return new KeyBindingData(KeyBindingData.validateKeyStroke(keyBinding), precedence);
    }

    public static KeyStroke validateKeyStroke(KeyStroke keyStroke) {
        int eventType;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 0x80) == 128) {
            modifiers ^= 0x80;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 1) == 1) {
            modifiers ^= 1;
            modifiers |= 0x40;
        }
        if ((modifiers & 8) == 8) {
            modifiers ^= 8;
            modifiers |= 0x200;
        }
        if ((modifiers & 4) == 4) {
            modifiers ^= 4;
            modifiers |= 0x100;
        }
        if ((eventType = keyStroke.getKeyEventType()) == 400) {
            return KeyStroke.getKeyStroke((int)keyStroke.getKeyChar(), modifiers);
        }
        boolean isOnKeyRelease = keyStroke.isOnKeyRelease();
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifiers, isOnKeyRelease);
    }
}

