/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import com.toedter.calendar.JCalendar;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.options.editor.ButtonPanelFactory;
import docking.options.editor.Clock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateEditor
extends PropertyEditorSupport {
    public static DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
    private static final int NUMBER_OF_COLUMNS = 20;
    private Date date;
    private CalendarPanel calendarPanel;
    private JTextField textField;
    private EditDateDialog dialog;
    private DateFormat dateFormat = DEFAULT_DATE_FORMAT;

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
        if (this.textField != null) {
            this.textField.setText(this.format(this.date));
        }
    }

    public synchronized String format(Date d) {
        return this.dateFormat.format(d);
    }

    @Override
    public Component getCustomEditor() {
        return new DatePanel();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Object getValue() {
        return this.date;
    }

    @Override
    public void setValue(Object value) {
        if (this.date != null && this.date.equals(value)) {
            return;
        }
        this.date = (Date)value;
        if (this.calendarPanel != null) {
            this.calendarPanel.setDate(this.date);
        }
        if (this.textField != null) {
            this.textField.setText(this.format(this.date));
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            Date newDate = this.dateFormat.parse(text);
            this.setValue(newDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse text as date: " + text);
        }
    }

    private void displayCalendarEditor(Component parent) {
        if (this.calendarPanel == null) {
            this.calendarPanel = new CalendarPanel();
        }
        if (this.date != null) {
            this.calendarPanel.setDate(this.date);
        }
        if (this.dialog == null) {
            this.dialog = new EditDateDialog(parent);
        }
        DockingWindowManager.showDialog(parent, this.dialog);
    }

    private class EditDateDialog
    extends DialogComponentProvider {
        EditDateDialog(Component parent) {
            super("Edit Date", true);
            JPanel dialogPanel = new JPanel();
            dialogPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            dialogPanel.setLayout(new BorderLayout());
            dialogPanel.add((Component)DateEditor.this.calendarPanel, "Center");
            this.addWorkPanel(dialogPanel);
            this.addOKButton();
            this.addCancelButton();
        }

        @Override
        protected void okCallback() {
            Date newDate = DateEditor.this.calendarPanel.jcal.getCalendar().getTime();
            DateEditor.this.setValue(newDate);
            DateEditor.this.firePropertyChange();
            this.close();
        }

        @Override
        protected void cancelCallback() {
            this.close();
        }
    }

    private class CalendarPanel
    extends JPanel
    implements PropertyChangeListener {
        private JCalendar jcal;
        private Clock clock;
        private SimpleDateFormat formatter;

        CalendarPanel() {
            super(new BorderLayout(0, 5));
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.jcal = new JCalendar();
            this.jcal.addPropertyChangeListener((PropertyChangeListener)this);
            this.clock = new Clock(this.jcal);
            this.add((Component)this.jcal, "Center");
            this.add((Component)this.clock, "South");
            this.formatter = new SimpleDateFormat("MM dd yyyy");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == null || propertyName.equals("calendar")) {
                Calendar newCal = (Calendar)evt.getNewValue();
                Date newDate = newCal.getTime();
                this.clock.update(newDate);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        void setDate(Date date) {
            Calendar calendar = this.jcal.getCalendar();
            Calendar c = (Calendar)calendar.clone();
            String dateString = this.formatter.format(date);
            int month = Integer.parseInt(dateString.substring(0, 2));
            int day = Integer.parseInt(dateString.substring(3, 5));
            int year = Integer.parseInt(dateString.substring(6));
            c.set(2, month);
            c.set(7, day);
            c.set(1, year);
            c.setTime(date);
            this.jcal.setCalendar(c);
            this.clock.update(date);
        }
    }

    private class DatePanel
    extends JPanel {
        private JButton browseButton;

        DatePanel() {
            BoxLayout bl = new BoxLayout(this, 0);
            this.setLayout(bl);
            DateEditor.this.textField = new JTextField(20);
            DateEditor.this.textField.setText(DateEditor.this.date != null ? DateEditor.this.format(DateEditor.this.date) : "");
            DateEditor.this.textField.setEditable(false);
            this.browseButton = ButtonPanelFactory.createButton(2);
            Font f = this.browseButton.getFont();
            f = new Font(f.getName(), 1, f.getSize());
            this.browseButton.setFont(f);
            this.add(DateEditor.this.textField);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.browseButton);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.browseButton.addActionListener(e -> DateEditor.this.displayCalendarEditor(this.browseButton));
        }
    }
}

