/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class VariableHeightLayoutManager
implements LayoutManager {
    final int hgap;
    final int vgap;
    boolean grid;

    VariableHeightLayoutManager(int hgap, int vgap, boolean pack) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.grid = !pack;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (parent.getParent() != null) {
            return this.getPreferredSize(parent, parent.getParent().getSize().width);
        }
        return this.getPreferredSize(parent, 0);
    }

    Dimension getPreferredSize(Container parent) {
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        if (n <= 0) {
            return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        }
        int width = 0;
        int height = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            height = Math.max(height, d.height);
            width += d.width;
        }
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    private Dimension getPreferredSize(Container parent, int maxWidth) {
        int rowHeight;
        if (maxWidth == 0) {
            return this.getPreferredSize(parent);
        }
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        if (n <= 0) {
            return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        }
        int horizontalInsets = insets.left + insets.right;
        int verticalInsets = insets.top + insets.bottom;
        Dimension standardSize = this.computeStandardComponentSize(parent);
        Component c = parent.getComponent(0);
        Dimension preferredSize = this.getPreferredDimensionForComponent(c, standardSize);
        int rowWidth = preferredSize.width;
        int height = rowHeight = this.getStandardComponentHeight(parent);
        int availableWidth = maxWidth - horizontalInsets;
        for (int i = 1; i < n; ++i) {
            c = parent.getComponent(i);
            preferredSize = this.getPreferredDimensionForComponent(c, standardSize);
            if (rowWidth + this.hgap + preferredSize.width <= availableWidth) {
                rowWidth += preferredSize.width + this.hgap;
                continue;
            }
            height += rowHeight + this.vgap;
            rowWidth = preferredSize.width;
        }
        return new Dimension(availableWidth + horizontalInsets, height + verticalInsets);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension parentSize = parent.getSize();
        int useableWidth = parentSize.width - insets.left - insets.right;
        int n = parent.getComponentCount();
        int x = insets.left;
        int y = insets.top;
        if (n == 0) {
            return;
        }
        Component c = parent.getComponent(0);
        Dimension standardSize = this.computeStandardComponentSize(parent);
        Dimension preferredSize = this.getPreferredDimensionForComponent(c, standardSize);
        c.setBounds(x, y, preferredSize.width, preferredSize.height);
        x += preferredSize.width + this.hgap;
        int rowHeight = this.getStandardComponentHeight(parent);
        int rowWidth = preferredSize.width;
        for (int i = 1; i < n; ++i) {
            c = parent.getComponent(i);
            preferredSize = this.getPreferredDimensionForComponent(c, standardSize);
            if (rowWidth + this.hgap + preferredSize.width <= useableWidth) {
                rowWidth += preferredSize.width + this.hgap;
                c.setBounds(x, y + (rowHeight - preferredSize.height) / 2, preferredSize.width, preferredSize.height);
                x += preferredSize.width + this.hgap;
                continue;
            }
            x = insets.left;
            rowWidth = preferredSize.width;
            c.setBounds(x, (y += rowHeight + this.vgap) + (rowHeight - preferredSize.height) / 2, preferredSize.width, preferredSize.height);
            x += preferredSize.width + this.hgap;
        }
    }

    private Dimension getPreferredDimensionForComponent(Component component, Dimension standardSize) {
        Dimension preferredDimension = component.getPreferredSize();
        if (this.grid) {
            preferredDimension.width = standardSize.width;
        }
        return preferredDimension;
    }

    int getStandardComponentHeight(Container parent) {
        int n = parent.getComponentCount();
        int compHeight = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            compHeight = Math.max(compHeight, d.height);
        }
        return compHeight;
    }

    Dimension computeStandardComponentSize(Container parent) {
        int n = parent.getComponentCount();
        int compWidth = 0;
        int compHeight = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            compWidth = Math.max(compWidth, d.width);
            compHeight = Math.max(compHeight, d.height);
        }
        return new Dimension(compWidth, compHeight);
    }
}

