/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InputWithChoicesDialog
extends DialogComponentProvider {
    private boolean isCanceled;
    private GhidraComboBox<String> combo;
    private boolean allowEdits;

    public InputWithChoicesDialog(String dialogTitle, String label, String[] optionValues, String initialValue, Icon messageIcon) {
        super(dialogTitle, true, false, true, false);
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.buildMainPanel(label, optionValues, initialValue, messageIcon);
        this.setFocusComponent(this.combo);
    }

    public InputWithChoicesDialog(String dialogTitle, String label, String[] optionValues, String initialValue, boolean allowEdits, Icon messageIcon) {
        super(dialogTitle, true, false, true, false);
        this.addOKButton();
        this.addCancelButton();
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.allowEdits = allowEdits;
        this.buildMainPanel(label, optionValues, initialValue, messageIcon);
        this.setFocusComponent(this.combo);
    }

    @Override
    protected void dialogShown() {
        this.combo.requestFocusInWindow();
    }

    private void buildMainPanel(String labelText, String[] optionValues, String initialValue, Icon messageIcon) {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel messageLabel = new JLabel();
        messageLabel.setText(labelText);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.combo = this.createComboBox(optionValues, initialValue);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)messageLabel, "North");
        dataPanel.add(this.combo, "South");
        workPanel.add((Component)dataPanel, "Center");
        if (messageIcon != null) {
            JLabel iconLabel = new JLabel();
            iconLabel.setIcon(messageIcon);
            iconLabel.setVerticalAlignment(1);
            JPanel separatorPanel = new JPanel();
            separatorPanel.setPreferredSize(new Dimension(15, 1));
            JPanel iconPanel = new JPanel(new BorderLayout());
            iconPanel.add((Component)iconLabel, "Center");
            iconPanel.add((Component)separatorPanel, "East");
            workPanel.add((Component)iconPanel, "West");
        }
        this.addWorkPanel(workPanel);
    }

    private GhidraComboBox<String> createComboBox(String[] optionValues, String initialValue) {
        GhidraComboBox<String> newComboBox = new GhidraComboBox<String>(optionValues);
        newComboBox.setEditable(this.allowEdits);
        newComboBox.addActionListener(e -> this.okCallback());
        if (initialValue != null) {
            newComboBox.setSelectedItem(initialValue);
        }
        return newComboBox;
    }

    @Override
    protected void okCallback() {
        this.isCanceled = false;
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getValue() {
        if (this.isCanceled) {
            return null;
        }
        Object selectedItem = this.combo.getSelectedItem();
        return selectedItem == null ? null : selectedItem.toString();
    }
}

