/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.TableFilter;
import java.util.ArrayList;
import java.util.List;

public class CombinedTableFilter<T>
implements TableFilter<T> {
    private final List<TableFilter<T>> filters = new ArrayList<TableFilter<T>>();

    public CombinedTableFilter(TableFilter<T> filter1, TableFilter<T> filter2, TableFilter<T> filter3) {
        this.addIfNotNull(filter1);
        this.addIfNotNull(filter2);
        this.addIfNotNull(filter3);
    }

    private void addIfNotNull(TableFilter<T> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    @Override
    public boolean acceptsRow(T rowObject) {
        for (TableFilter<T> tableFilter : this.filters) {
            if (tableFilter.acceptsRow(rowObject)) continue;
            return false;
        }
        return true;
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public TableFilter<?> getFilter(int index) {
        return this.filters.get(index);
    }

    @Override
    public boolean isSubFilterOf(TableFilter<?> tableFilter) {
        if (!(tableFilter instanceof CombinedTableFilter)) {
            return false;
        }
        CombinedTableFilter other = (CombinedTableFilter)tableFilter;
        if (this.getFilterCount() != other.getFilterCount()) {
            return false;
        }
        if (this.getFilterCount() == 0) {
            return false;
        }
        for (int i = 0; i < this.getFilterCount(); ++i) {
            if (this.getFilter(i).isSubFilterOf(other.getFilter(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasColumnFilter(int modelIndex) {
        for (TableFilter<T> tableFilter : this.filters) {
            if (!tableFilter.hasColumnFilter(modelIndex)) continue;
            return true;
        }
        return false;
    }
}

