/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.SortListener;
import docking.widgets.table.TableSortState;
import java.util.Comparator;
import javax.swing.table.TableModel;

public interface SortedTableModel
extends TableModel {
    public static final Comparator<Object> DEFAULT_COMPARATOR = new DefaultComparator();
    public static final boolean ASCENDING_ORDER = true;
    public static final boolean DESCENDING_ORDER = false;

    public boolean isSortable(int var1);

    public int getPrimarySortColumnIndex();

    public void setTableSortState(TableSortState var1);

    public TableSortState getTableSortState();

    public void addSortListener(SortListener var1);

    public static class DefaultComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return this.handleNullValues(o1, o2);
            }
            if (String.class == o1.getClass() && String.class == o2.getClass()) {
                return this.compareAsStrings(o1, o2);
            }
            if (Comparable.class.isAssignableFrom(o1.getClass()) && o1.getClass() == o2.getClass()) {
                Comparable comparable = (Comparable)o1;
                int result = comparable.compareTo(o2);
                return result;
            }
            return this.compareAsStrings(o1, o2);
        }

        private int handleNullValues(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return 1;
        }

        private int compareAsStrings(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

