/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import util.CollectionUtils;

public class GTreeState {
    private static final int MAX_ITEM_COUNT = 50;
    private List<TreePath> expandedPaths;
    private List<TreePath> selectionPaths;
    private LinkedHashSet<TreePath> viewPaths;
    private GTree tree;

    public GTreeState(GTree tree) {
        this(tree, tree.getRootNode());
    }

    public GTreeState(GTree tree, GTreeNode node) {
        this.tree = tree;
        this.expandedPaths = tree.getExpandedPaths(node);
        this.selectionPaths = this.getSelectionPaths(node);
        this.viewPaths = this.getSomeViewPaths();
        this.adjustPathsForSizeConstraint();
    }

    private void adjustPathsForSizeConstraint() {
        this.doAdjustPathsForSizeConstraint();
    }

    private void doAdjustPathsForSizeConstraint() {
        int maxSize = this.getMaxItemCount();
        int combinedSize = this.selectionPaths.size() + this.expandedPaths.size();
        if (combinedSize < maxSize) {
            return;
        }
        LinkedHashSet<TreePath> limitedViewPaths = this.getViewPaths(maxSize);
        this.expandedPaths = new ArrayList<TreePath>(limitedViewPaths);
        if (this.selectionPaths.size() > maxSize) {
            this.selectionPaths.retainAll(limitedViewPaths);
            return;
        }
        this.expandedPaths.addAll(this.selectionPaths);
    }

    int getMaxItemCount() {
        return 50;
    }

    public List<TreePath> getExpandedPaths() {
        return Collections.unmodifiableList(this.expandedPaths);
    }

    public List<TreePath> getSelectedPaths() {
        return Collections.unmodifiableList(this.selectionPaths);
    }

    public TreePath[] getViewPaths() {
        TreePath[] arrrr = this.viewPaths.toArray(new TreePath[this.viewPaths.size()]);
        return arrrr;
    }

    public void updateStateForMovedNodes() {
        int i;
        for (i = 0; i < this.expandedPaths.size(); ++i) {
            this.expandedPaths.set(i, this.updatePathForMovedNode(this.expandedPaths.get(i)));
        }
        for (i = 0; i < this.selectionPaths.size(); ++i) {
            this.selectionPaths.set(i, this.updatePathForMovedNode(this.selectionPaths.get(i)));
        }
    }

    public boolean isEmpty() {
        return this.selectionPaths.isEmpty() && this.expandedPaths.isEmpty();
    }

    private TreePath updatePathForMovedNode(TreePath path) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        return node.getTreePath();
    }

    private List<TreePath> getSelectionPaths(GTreeNode node) {
        Object[] allSelectionPaths = this.tree.getSelectionPaths();
        if (node == this.tree.getRootNode()) {
            return CollectionUtils.asList((Object[])allSelectionPaths);
        }
        if (allSelectionPaths == null) {
            return Collections.emptyList();
        }
        TreePath nodeTreePath = node.getTreePath();
        ArrayList<TreePath> pathList = new ArrayList<TreePath>();
        for (Object path : allSelectionPaths) {
            if (!nodeTreePath.isDescendant((TreePath)path)) continue;
            pathList.add(nodeTreePath);
        }
        return pathList;
    }

    private LinkedHashSet<TreePath> getSomeViewPaths() {
        int arbitrarySize = 5;
        return this.getViewPaths(arbitrarySize);
    }

    private LinkedHashSet<TreePath> getViewPaths(int limit) {
        Rectangle r = this.tree.getViewRect();
        JTree jTree = this.tree.getJTree();
        int top = jTree.getClosestRowForLocation(r.x, r.y);
        int bottom = jTree.getClosestRowForLocation(r.x, r.y + r.height);
        int end = ++bottom - limit;
        end = Math.max(end, --top);
        LinkedHashSet<TreePath> result = new LinkedHashSet<TreePath>();
        for (int i = bottom; i > end; --i) {
            TreePath path = jTree.getPathForRow(i);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    public String toString() {
        return "GTreeState[Selection: " + this.getPaths(this.selectionPaths) + ", Expansion: " + this.getPaths(this.expandedPaths) + "]";
    }

    private String getPaths(List<TreePath> paths) {
        StringBuffer buffer = new StringBuffer();
        for (TreePath treePath : paths) {
            buffer.append(treePath);
        }
        return buffer.toString();
    }
}

