/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JComboBox;

public class PropertySelector
extends JComboBox
implements ItemListener {
    private PropertyEditor editor;
    private boolean notifyEditorOfChanges = true;

    public PropertySelector(PropertyEditor pe) {
        this.editor = pe;
        String[] tags = this.editor.getTags();
        for (int i = 0; i < tags.length; ++i) {
            this.addItem(tags[i]);
        }
        this.setSelectedIndex(0);
        this.setSelectedItem(this.editor.getAsText());
        this.addItemListener(this);
        this.invalidate();
        this.editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String value = PropertySelector.this.editor.getAsText();
                if (!value.equals(PropertySelector.this.getSelectedItem())) {
                    PropertySelector.this.notifyEditorOfChanges = false;
                    try {
                        PropertySelector.this.setSelectedItem(value);
                    }
                    finally {
                        PropertySelector.this.notifyEditorOfChanges = true;
                    }
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.notifyEditorOfChanges) {
            String s = (String)this.getSelectedItem();
            this.editor.setAsText(s);
        }
    }
}

