/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.exception.IOCancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends InputStream {
    private static final int PROGRESS_INCREMENT = 32768;
    protected InputStream in;
    private TaskMonitor monitor;
    private int smallCount = 0;
    private int count = 0;

    public MonitoredInputStream(InputStream in, TaskMonitor monitor) {
        this.in = in;
        this.monitor = monitor;
    }

    public void setProgress(int count) {
        this.count = count;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.smallCount;
            if (this.smallCount >= 32768) {
                if (this.monitor.isCancelled()) {
                    throw new IOCancelledException();
                }
                this.count += this.smallCount;
                this.smallCount = 0;
                this.monitor.setProgress((long)this.count);
            }
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        this.smallCount += n;
        if (this.smallCount >= 32768) {
            if (this.monitor.isCancelled()) {
                throw new IOCancelledException();
            }
            this.count += this.smallCount;
            this.smallCount = 0;
            this.monitor.setProgress((long)this.count);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

