/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.Msg;
import ghidra.util.classfinder.ClassFinder;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ClassPackage {
    private static final FileFilter CLASS_FILTER = pathname -> pathname.getName().endsWith(".class");
    private Set<String> classNames = new HashSet<String>();
    private Set<Class<?>> classes = null;
    private List<ClassPackage> children = new ArrayList<ClassPackage>();
    private File rootDir;
    private String packageName;

    ClassPackage(File rootDir, String packageName, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        this.rootDir = rootDir;
        this.packageName = packageName;
        this.scanClasses();
        this.scanSubPackages(monitor);
    }

    private void scanClasses() {
        this.classNames.clear();
        this.classes = new HashSet();
        String path = this.rootDir.getAbsolutePath();
        List<String> allClassNames = this.getAllClassNames();
        for (String className : allClassNames) {
            Class<?> c = ClassFinder.loadExtensionPoint(path, className);
            if (c == null) continue;
            this.classes.add(c);
            this.classNames.add(c.getName());
        }
    }

    private void scanSubPackages(TaskMonitor monitor) throws CancelledException {
        this.children.clear();
        File dir = this.getPackageDir(this.rootDir, this.packageName);
        File[] subdirs = dir.listFiles();
        if (subdirs == null) {
            Msg.debug((Object)this, (Object)("Directory does not exist: " + dir));
            return;
        }
        for (File subdir : subdirs) {
            if (!subdir.isDirectory()) continue;
            monitor.checkCanceled();
            Object pkg = subdir.getName();
            if (((String)pkg).contains(".")) continue;
            if (this.packageName.length() > 0) {
                pkg = this.packageName + "." + (String)pkg;
            }
            monitor.setMessage("scanning package: " + (String)pkg);
            this.children.add(new ClassPackage(this.rootDir, (String)pkg, monitor));
        }
    }

    void rescan(TaskMonitor monitor) throws CancelledException, FileNotFoundException {
        monitor.checkCanceled();
        this.scanClasses();
        File dir = this.getPackageDir(this.rootDir, this.packageName);
        String rootPath = this.rootDir.getAbsolutePath();
        String dirPath = dir.getAbsolutePath();
        dirPath = dirPath.substring(rootPath.length());
        monitor.setMessage("scanning directory: " + this.rootDir.getName() + dirPath);
        File[] subdirs = dir.listFiles();
        if (subdirs == null) {
            Msg.debug((Object)this, (Object)("Directory does not exist: " + dir));
            return;
        }
        HashSet<String> pkgNames = new HashSet<String>();
        for (File subdir : subdirs) {
            Object name;
            monitor.checkCanceled();
            if (!subdir.isDirectory() || ((String)(name = subdir.getName())).contains(".")) continue;
            if (this.packageName.length() > 0) {
                name = this.packageName + "." + (String)name;
            }
            pkgNames.add((String)name);
        }
        Iterator<ClassPackage> classPackageIterator = this.children.iterator();
        while (classPackageIterator.hasNext()) {
            monitor.checkCanceled();
            ClassPackage pkg = classPackageIterator.next();
            if (!pkgNames.contains(pkg.packageName)) {
                classPackageIterator.remove();
                continue;
            }
            pkg.rescan(monitor);
            pkgNames.remove(pkg.packageName);
        }
        Iterator packageNameIterator = pkgNames.iterator();
        while (packageNameIterator.hasNext()) {
            monitor.checkCanceled();
            String pkgName = (String)packageNameIterator.next();
            this.children.add(new ClassPackage(this.rootDir, pkgName, monitor));
        }
    }

    private File getPackageDir(File lRootDir, String lPackageName) {
        return new File(lRootDir, lPackageName.replace('.', File.separatorChar));
    }

    void getClasses(Set<Class<?>> set, TaskMonitor monitor) throws CancelledException {
        set.addAll(this.classes);
        Iterator<ClassPackage> classPackageIterator = this.children.iterator();
        while (classPackageIterator.hasNext()) {
            monitor.checkCanceled();
            ClassPackage subPkg = classPackageIterator.next();
            subPkg.getClasses(set, monitor);
        }
    }

    private List<String> getAllClassNames() {
        File dir = this.getPackageDir(this.rootDir, this.packageName);
        File[] files = dir.listFiles(CLASS_FILTER);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(files.length);
        for (File file : files) {
            Object name = file.getName();
            name = ((String)name).substring(0, ((String)name).length() - 6);
            if (this.packageName.length() > 0) {
                name = this.packageName + "." + (String)name;
            }
            results.add((String)name);
        }
        return results;
    }
}

