/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.ShortKeyIndexer;
import ghidra.util.exception.NoValueException;
import java.io.Serializable;

public class ShortByteHashtable
implements Serializable {
    private ShortKeyIndexer indexer;
    private byte[] values;
    private int capacity;

    public ShortByteHashtable() {
        this(3);
    }

    public ShortByteHashtable(short capacity) {
        capacity = (short)Prime.nextPrime(capacity);
        this.capacity = capacity;
        this.indexer = new ShortKeyIndexer(capacity);
        this.values = new byte[capacity];
    }

    public void put(short key, byte value) {
        short index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public byte get(short key) throws NoValueException {
        short index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public boolean remove(short key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(short key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public short[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        byte[] oldValues = this.values;
        this.values = new byte[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

