/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.DecompileProcess;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileNotFoundException;

class DecompileProcessFactory {
    private static String exepath;
    private static final String EXECNAME = "decompile";
    private static final String WIN32_EXECNAME = "decompile.exe";

    DecompileProcessFactory() {
    }

    static synchronized DecompileProcess get() {
        DecompileProcessFactory.getExePath();
        DecompileProcess currentProcess = new DecompileProcess(exepath);
        return currentProcess;
    }

    static synchronized void release(DecompileProcess dp) {
        dp.dispose();
    }

    private static void getExePath() {
        if (exepath != null) {
            return;
        }
        String exeName = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? WIN32_EXECNAME : EXECNAME;
        try {
            File file = Application.getOSFile((String)exeName);
            exepath = file.getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            Msg.showError(DecompileProcessFactory.class, null, (String)"Decompiler missing", (Object)("Could not find decompiler executable " + exeName));
        }
    }
}

