/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class CommitLocalsAction
extends DockingAction {
    private final DecompilerController controller;

    public CommitLocalsAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Commit Locals", owner);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Commit Locals"}, "Commit"));
        this.setDescription("Save Local variable definitions to Program, locking them into their current type definitions");
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        Function function = this.controller.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return this.getHighFunction() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        Program program = this.controller.getProgram();
        int transaction = program.startTransaction("Commit Params/Return");
        try {
            HighFunction hfunc = this.getHighFunction();
            HighFunctionDBUtil.commitLocalsToDatabase((HighFunction)hfunc, (SourceType)SourceType.USER_DEFINED);
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }

    private HighFunction getHighFunction() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return null;
        }
        ClangFunction clfunc = tokenAtCursor.getClangFunction();
        if (clfunc == null) {
            return null;
        }
        return clfunc.getHighFunction();
    }
}

