/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.renderer.MouseClickedPaintableShape;
import ghidra.graph.viewer.renderer.MouseDebugPaintable;
import ghidra.graph.viewer.renderer.MouseDraggedLinePaintableShape;
import ghidra.graph.viewer.renderer.MouseDraggedPaintableShape;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.Objects;

public class VisualGraphMouseTrackingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener,
VisualGraphMousePlugin<V, E> {
    private MouseDebugPaintable paintable = new MouseDebugPaintable();
    private GraphViewer<V, E> viewer;
    private Point dragEnd;
    private MouseDraggedPaintableShape dragShape;
    private MouseDraggedLinePaintableShape dragLineShape;
    private int mouseMovedCount;

    public VisualGraphMouseTrackingGraphMousePlugin(GraphViewer<V, E> viewer) {
        super(28);
        this.viewer = Objects.requireNonNull(viewer);
        viewer.addPostRenderPaintable(this.paintable);
    }

    public boolean checkModifiers(MouseEvent e) {
        int eventModifiers = e.getModifiers();
        return ((eventModifiers = this.turnOffControlKey(eventModifiers)) & this.getModifiers()) == eventModifiers;
    }

    private int turnOffControlKey(int eventModifiers) {
        return eventModifiers & ~DockingUtils.CONTROL_KEY_MODIFIER_MASK;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point gp;
        RenderContext rc = this.viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        MutableTransformer layoutXformer = multiLayerTransformer.getTransformer(Layer.LAYOUT);
        AffineTransform layoutXform = layoutXformer.getTransform();
        double tx = layoutXform.getTranslateX();
        double ty = layoutXform.getTranslateY();
        Point p = e.getPoint();
        this.dragEnd = gp = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(p, this.viewer);
        Point gDown = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(this.down, this.viewer);
        if (this.dragShape == null) {
            this.dragShape = new MouseDraggedPaintableShape(gDown, gp, tx, ty);
            this.paintable.addShape(this.dragShape, this.viewer);
        } else {
            this.dragShape.setPoints(gDown, this.dragEnd);
        }
        int offset = 20;
        Point downOver = new Point(this.down.x + offset, this.down.y + offset);
        Point pOver = new Point(p.x + offset, p.y + offset);
        Point gpOver = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(pOver, this.viewer);
        if (this.dragLineShape == null) {
            Point gDownOver = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(downOver, this.viewer);
            this.dragLineShape = new MouseDraggedLinePaintableShape(gDownOver, gpOver, tx, ty);
            this.paintable.addShape(this.dragLineShape, this.viewer);
        } else {
            this.dragLineShape.addPoint(gpOver);
        }
        this.viewer.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (++this.mouseMovedCount % 5 == 0) {
            this.addPointMousePaintable(e, new Color(0, 255, 0, 127));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int button = e.getButton();
        if (button == 2) {
            this.paintable.clear();
            return;
        }
        this.addPointMousePaintable(e, Color.ORANGE);
    }

    private void addPointMousePaintable(MouseEvent e, Color color) {
        Point p = e.getPoint();
        Point gp = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(p, this.viewer);
        RenderContext rc = this.viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        MutableTransformer layoutXformer = multiLayerTransformer.getTransformer(Layer.LAYOUT);
        AffineTransform layoutXform = layoutXformer.getTransform();
        double tx = layoutXform.getTranslateX();
        double ty = layoutXform.getTranslateY();
        MouseClickedPaintableShape ps = new MouseClickedPaintableShape(gp, tx, ty, color);
        this.paintable.addShape(ps, this.viewer);
        this.viewer.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p;
        this.down = p = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.down = null;
        this.dragEnd = null;
        if (this.dragShape != null) {
            this.dragShape.shapeFinished();
            this.dragShape = null;
        }
        if (this.dragLineShape != null) {
            this.dragLineShape.shapeFinished();
            this.dragLineShape = null;
        }
        this.viewer.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

