/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import ghidra.bitpatterns.gui.MineSequenceTask;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.closedpatternmining.ClosedSequenceMiner;
import ghidra.closedpatternmining.FrequentSequence;
import ghidra.closedpatternmining.Sequence;
import ghidra.closedpatternmining.SequenceDatabase;
import ghidra.closedpatternmining.SequenceItem;
import ghidra.util.Msg;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ClosedPatternRowObject {
    private String dittedString;
    private int fixedBits;
    private int numOccurrences;
    private double percentage;
    private PatternInfoRowObject patternInfo;

    private ClosedPatternRowObject(String minedString, int fixedBits, int numOccurrences, double percentage, boolean isBinary, PatternType type, ContextRegisterFilter cRegFilter) {
        this.fixedBits = fixedBits;
        this.numOccurrences = numOccurrences;
        this.percentage = percentage;
        this.patternInfo = this.getPatternInfo(minedString, isBinary, type, cRegFilter);
        this.dittedString = this.patternInfo.getDittedBitSequence().getHexString();
    }

    private PatternInfoRowObject getPatternInfo(String minedString, boolean isBinary, PatternType type, ContextRegisterFilter cRegFilter) {
        DittedBitSequence seq = null;
        seq = isBinary ? this.getDittedBitSequenceBinary(minedString) : this.getDittedBitSequenceNibble(minedString);
        return new PatternInfoRowObject(type, seq, cRegFilter);
    }

    private DittedBitSequence getDittedBitSequenceNibble(String minedString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < minedString.length(); ++i) {
            if (minedString.charAt(i) == '.') {
                sb.append("....");
                continue;
            }
            String nibble = minedString.substring(i, i + 1);
            Object binaryString = Integer.toBinaryString(Integer.parseInt(nibble, 16));
            int missing = 4 - ((String)binaryString).length();
            switch (missing) {
                case 1: {
                    binaryString = "0" + (String)binaryString;
                    break;
                }
                case 2: {
                    binaryString = "00" + (String)binaryString;
                    break;
                }
                case 3: {
                    binaryString = "000" + (String)binaryString;
                    break;
                }
            }
            sb.append((String)binaryString);
        }
        return new DittedBitSequence(sb.toString(), false);
    }

    private DittedBitSequence getDittedBitSequenceBinary(String minedString) {
        DittedBitSequence seq = new DittedBitSequence(minedString, false);
        return seq;
    }

    public static List<ClosedPatternRowObject> mineClosedPatterns(List<ByteSequenceRowObject> byteSeqRowObjects, double minPercentage, int minFixedBits, boolean useBinary, PatternType type, ContextRegisterFilter cRegFilter, Component parent) {
        ArrayList<Sequence> seqsToMine = new ArrayList<Sequence>();
        for (ByteSequenceRowObject byteSeqRowObject : byteSeqRowObjects) {
            String seq = byteSeqRowObject.getSequence();
            Integer count = byteSeqRowObject.getNumOccurrences();
            if (useBinary) {
                StringBuilder paddedString = new StringBuilder();
                for (int i = 0; i < seq.length(); ++i) {
                    String currentChar = seq.substring(i, i + 1);
                    String unpaddedChar = Integer.toBinaryString(Integer.parseInt(currentChar, 16));
                    StringBuilder paddedChar = new StringBuilder();
                    switch (unpaddedChar.length()) {
                        case 1: {
                            paddedChar.append("000");
                            break;
                        }
                        case 2: {
                            paddedChar.append("00");
                            break;
                        }
                        case 3: {
                            paddedChar.append("0");
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            Msg.info(ClosedPatternRowObject.class, (Object)("Shouldn't happen, unpaddedString = " + unpaddedChar));
                        }
                    }
                    paddedString.append((CharSequence)paddedChar);
                    paddedString.append(unpaddedChar);
                }
                seq = paddedString.toString();
            }
            seqsToMine.add(new Sequence(seq, count));
        }
        int length = byteSeqRowObjects.get(0).getSequence().length();
        if (useBinary) {
            length = 4 * length;
        }
        SequenceDatabase database = new SequenceDatabase(seqsToMine, length);
        int minSupport = (int)((double)database.getTotalNumSeqs() * minPercentage);
        ClosedSequenceMiner miner = new ClosedSequenceMiner(database, minSupport);
        Set<FrequentSequence> closedSeqs = null;
        if (parent == null) {
            closedSeqs = miner.mineClosedSequences(TaskMonitor.DUMMY);
        } else {
            MineSequenceTask mineTask = new MineSequenceTask(miner);
            TaskLauncher launcher = new TaskLauncher((Task)mineTask, parent);
            closedSeqs = mineTask.getClosedSeqs();
        }
        ArrayList<ClosedPatternRowObject> rowObjects = new ArrayList<ClosedPatternRowObject>();
        int totalNumSeqs = database.getTotalNumSeqs();
        for (FrequentSequence seq : closedSeqs) {
            ClosedPatternRowObject rowObject = ClosedPatternRowObject.createClosedPatternRowObject(seq.getSequence(), seq.getSupport(), totalNumSeqs, useBinary, length, type, cRegFilter);
            if (rowObject.getNumFixedBits() < minFixedBits) continue;
            rowObjects.add(rowObject);
        }
        Msg.info(ClosedPatternRowObject.class, (Object)("\nFound " + closedSeqs.size() + " patterns"));
        return rowObjects;
    }

    private static ClosedPatternRowObject createClosedPatternRowObject(List<SequenceItem> items, Integer support, int totalNumSeqs, boolean isBinary, int length, PatternType type, ContextRegisterFilter cRegFilter) {
        String dittedString = ClosedPatternRowObject.getDittedStringFromItemList(items, length);
        int fixedBits = ClosedPatternRowObject.getFixedBits(items);
        if (!isBinary) {
            fixedBits *= 4;
        }
        double percentage = Math.round(100.0 * (double)support.intValue() / (double)totalNumSeqs);
        return new ClosedPatternRowObject(dittedString, fixedBits, support, percentage, isBinary, type, cRegFilter);
    }

    private static int getFixedBits(List<SequenceItem> items) {
        return items.size();
    }

    private static String getDittedStringFromItemList(List<SequenceItem> items, int length) {
        StringBuilder sb = new StringBuilder();
        int currentPosition = 0;
        for (SequenceItem item : items) {
            while (currentPosition < item.getIndex()) {
                sb.append(".");
                ++currentPosition;
            }
            sb.append(item.getSymbol());
            ++currentPosition;
        }
        while (sb.length() < length) {
            sb.append(".");
        }
        return sb.toString();
    }

    public String getDittedString() {
        return this.dittedString;
    }

    public int getNumFixedBits() {
        return this.fixedBits;
    }

    public int getNumOccurrences() {
        return this.numOccurrences;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public PatternInfoRowObject getPatternInfo() {
        return this.patternInfo;
    }
}

