/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.javaclass.flags;

public final class MethodsInfoAccessFlags {

	/** Declared public; may be accessed from outside its package. */
	public final static short ACC_PUBLIC = 0x0001;
	/** Declared private; accessible only within the defining class. */
	public final static short ACC_PRIVATE = 0x0002;
	/** Declared protected; may be accessed within subclasses. */
	public final static short ACC_PROTECTED = 0x0004;
	/** Declared static. */
	public final static short ACC_STATIC = 0x0008;
	/** Declared final; must not be overridden (5.4.5). */
	public final static short ACC_FINAL = 0x0010;
	/** Declared synchronized; invocation is wrapped by a monitor use. */
	public final static short ACC_SYNCHRONIZED = 0x0020;
	/** A bridge method, generated by the compiler. */
	public final static short ACC_BRIDGE = 0x0040;
	/** Declared with variable number of arguments. */
	public final static short ACC_VARARGS = 0x0080;
	/** Declared native; implemented in a language other than Java. */
	public final static short ACC_NATIVE = 0x0100;
	/** Declared abstract; no implementation is provided. */
	public final static short ACC_ABSTRACT = 0x0400;
	/** Declared strictfp; floating-point mode is FP-strict. */
	public final static short ACC_STRICT = 0x0800;
	/** Declared synthetic; not present in the source code. */
	public final static short ACC_SYNTHETIC = 0x1000;

}
