/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.List;

public class MethodInlineAttr
implements IAttribute {
    private final InsnNode insn;
    private final int[] argsRegNums;

    public static void markForInline(MethodNode mth, InsnNode replaceInsn) {
        List<RegisterArg> allArgRegs = mth.getAllArgRegs();
        int argsCount = allArgRegs.size();
        int[] regNums = new int[argsCount];
        for (int i = 0; i < argsCount; ++i) {
            RegisterArg reg = allArgRegs.get(i);
            regNums[i] = reg.getRegNum();
        }
        mth.addAttr(new MethodInlineAttr(replaceInsn, regNums));
    }

    private MethodInlineAttr(InsnNode insn, int[] argsRegNums) {
        this.insn = insn;
        this.argsRegNums = argsRegNums;
    }

    public InsnNode getInsn() {
        return this.insn;
    }

    public int[] getArgsRegNums() {
        return this.argsRegNums;
    }

    public AType<MethodInlineAttr> getType() {
        return AType.METHOD_INLINE;
    }

    public String toString() {
        return "INLINE: " + this.insn;
    }
}

