/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class ArgType {
    public static final ArgType INT = ArgType.primitive(PrimitiveType.INT);
    public static final ArgType BOOLEAN = ArgType.primitive(PrimitiveType.BOOLEAN);
    public static final ArgType BYTE = ArgType.primitive(PrimitiveType.BYTE);
    public static final ArgType SHORT = ArgType.primitive(PrimitiveType.SHORT);
    public static final ArgType CHAR = ArgType.primitive(PrimitiveType.CHAR);
    public static final ArgType FLOAT = ArgType.primitive(PrimitiveType.FLOAT);
    public static final ArgType DOUBLE = ArgType.primitive(PrimitiveType.DOUBLE);
    public static final ArgType LONG = ArgType.primitive(PrimitiveType.LONG);
    public static final ArgType VOID = ArgType.primitive(PrimitiveType.VOID);
    public static final ArgType OBJECT = ArgType.object("java.lang.Object");
    public static final ArgType CLASS = ArgType.object("java.lang.Class");
    public static final ArgType STRING = ArgType.object("java.lang.String");
    public static final ArgType ENUM = ArgType.object("java.lang.Enum");
    public static final ArgType THROWABLE = ArgType.object("java.lang.Throwable");
    public static final ArgType OBJECT_ARRAY = ArgType.array(OBJECT);
    public static final ArgType UNKNOWN = ArgType.unknown(PrimitiveType.values());
    public static final ArgType UNKNOWN_OBJECT = ArgType.unknown(PrimitiveType.OBJECT, PrimitiveType.ARRAY);
    public static final ArgType UNKNOWN_OBJECT_NO_ARRAY = ArgType.unknown(PrimitiveType.OBJECT);
    public static final ArgType UNKNOWN_ARRAY = ArgType.array(UNKNOWN);
    public static final ArgType NARROW = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.BOOLEAN, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR, PrimitiveType.OBJECT, PrimitiveType.ARRAY);
    public static final ArgType NARROW_NUMBERS = ArgType.unknown(PrimitiveType.BOOLEAN, PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR);
    public static final ArgType NARROW_INTEGRAL = ArgType.unknown(PrimitiveType.INT, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR);
    public static final ArgType NARROW_NUMBERS_NO_BOOL = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR);
    public static final ArgType NARROW_NUMBERS_NO_FLOAT = ArgType.unknown(PrimitiveType.INT, PrimitiveType.BOOLEAN, PrimitiveType.SHORT, PrimitiveType.BYTE, PrimitiveType.CHAR);
    public static final ArgType WIDE = ArgType.unknown(PrimitiveType.LONG, PrimitiveType.DOUBLE);
    public static final ArgType INT_FLOAT = ArgType.unknown(PrimitiveType.INT, PrimitiveType.FLOAT);
    protected int hash;

    private static ArgType primitive(PrimitiveType stype) {
        return new PrimitiveArg(stype);
    }

    public static ArgType object(String obj) {
        return new ObjectType(obj);
    }

    public static ArgType genericType(String type) {
        return new GenericType(type);
    }

    public static ArgType wildcard() {
        return new WildcardType(OBJECT, WildcardBound.UNBOUND);
    }

    public static ArgType wildcard(ArgType obj, WildcardBound bound) {
        return new WildcardType(obj, bound);
    }

    public static ArgType parseGenericSignature(String sign) {
        return new SignatureParser(sign).consumeType();
    }

    public static ArgType generic(String obj, ArgType ... generics) {
        return new GenericObject(obj, generics);
    }

    public static ArgType outerGeneric(ArgType genericOuterType, ArgType innerType) {
        return new OuterGenericObject((GenericObject)genericOuterType, (ObjectType)innerType);
    }

    public static ArgType array(ArgType vtype) {
        return new ArrayArg(vtype);
    }

    public static ArgType unknown(PrimitiveType ... types) {
        return new UnknownArg(types);
    }

    public boolean isTypeKnown() {
        return false;
    }

    public PrimitiveType getPrimitiveType() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public String getObject() {
        throw new UnsupportedOperationException("ArgType.getObject(), call class: " + this.getClass());
    }

    public boolean isObject() {
        return false;
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public ArgType[] getGenericTypes() {
        return null;
    }

    public List<ArgType> getExtendTypes() {
        return Collections.emptyList();
    }

    public void setExtendTypes(List<ArgType> extendTypes) {
    }

    public ArgType getWildcardType() {
        return null;
    }

    public WildcardBound getWildcardBound() {
        return null;
    }

    public ArgType getOuterType() {
        return null;
    }

    public ArgType getInnerType() {
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public int getArrayDimension() {
        return 0;
    }

    public ArgType getArrayElement() {
        return null;
    }

    public ArgType getArrayRootElement() {
        return this;
    }

    public abstract boolean contains(PrimitiveType var1);

    public abstract ArgType selectFirst();

    public abstract PrimitiveType[] getPossibleTypes();

    public static boolean isCastNeeded(DexNode dex, ArgType from, ArgType to) {
        if (from.equals(to)) {
            return false;
        }
        return !from.isObject() || !to.isObject() || !dex.root().getClsp().isImplements(from.getObject(), to.getObject());
    }

    public static boolean isInstanceOf(RootNode root, ArgType type, ArgType of) {
        if (type.equals(of)) {
            return true;
        }
        if (!type.isObject() || !of.isObject()) {
            return false;
        }
        return root.getClsp().isImplements(type.getObject(), of.getObject());
    }

    public static boolean isClsKnown(RootNode root, ArgType cls) {
        if (cls.isObject()) {
            return root.getClsp().isClsKnown(cls.getObject());
        }
        return false;
    }

    public boolean canBeObject() {
        return this.isObject() || !this.isTypeKnown() && this.contains(PrimitiveType.OBJECT);
    }

    public boolean canBeArray() {
        return this.isArray() || !this.isTypeKnown() && this.contains(PrimitiveType.ARRAY);
    }

    public boolean canBePrimitive(PrimitiveType primitiveType) {
        return this.isPrimitive() && this.getPrimitiveType() == primitiveType || !this.isTypeKnown() && this.contains(primitiveType);
    }

    public static ArgType convertFromPrimitiveType(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case CHAR: {
                return CHAR;
            }
            case BYTE: {
                return BYTE;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
            case ARRAY: {
                return OBJECT_ARRAY;
            }
            case VOID: {
                return VOID;
            }
        }
        return OBJECT;
    }

    public static ArgType parse(String type) {
        char f = type.charAt(0);
        switch (f) {
            case 'L': {
                return ArgType.object(type);
            }
            case 'T': {
                return ArgType.genericType(type.substring(1, type.length() - 1));
            }
            case '[': {
                return ArgType.array(ArgType.parse(type.substring(1)));
            }
        }
        return ArgType.parse(f);
    }

    public static ArgType parse(char f) {
        switch (f) {
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'J': {
                return LONG;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                return VOID;
            }
        }
        return null;
    }

    public int getRegCount() {
        if (this.isPrimitive()) {
            PrimitiveType type = this.getPrimitiveType();
            if (type == PrimitiveType.LONG || type == PrimitiveType.DOUBLE) {
                return 2;
            }
            return 1;
        }
        if (!this.isTypeKnown()) {
            return 0;
        }
        return 1;
    }

    public boolean containsGenericType() {
        if (this.isGenericType()) {
            return true;
        }
        ArgType wildcardType = this.getWildcardType();
        if (wildcardType != null) {
            return wildcardType.containsGenericType();
        }
        if (this.isGeneric()) {
            ArgType[] genericTypes = this.getGenericTypes();
            if (genericTypes != null) {
                for (ArgType genericType : genericTypes) {
                    if (!genericType.containsGenericType()) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static ArgType tryToResolveClassAlias(DexNode dex, ArgType type) {
        if (!type.isObject() || type.isGenericType()) {
            return type;
        }
        ClassNode cls = dex.resolveClass(type);
        if (cls == null) {
            return type;
        }
        ClassInfo clsInfo = cls.getClassInfo();
        if (!clsInfo.hasAlias()) {
            return type;
        }
        String aliasFullName = clsInfo.getAliasFullName();
        if (type.isGeneric()) {
            if (type instanceof GenericObject) {
                return new GenericObject(aliasFullName, type.getGenericTypes());
            }
            if (type instanceof WildcardType) {
                return new WildcardType(ArgType.object(aliasFullName), type.getWildcardBound());
            }
        }
        return ArgType.object(aliasFullName);
    }

    public String toString() {
        return "ARG_TYPE";
    }

    public int hashCode() {
        return this.hash;
    }

    abstract boolean internalEquals(Object var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.hash != obj.hashCode()) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.internalEquals(obj);
    }

    private static final class UnknownArg
    extends ArgType {
        private final PrimitiveType[] possibleTypes;

        public UnknownArg(PrimitiveType[] types) {
            this.possibleTypes = types;
            this.hash = Arrays.hashCode((Object[])this.possibleTypes);
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return this.possibleTypes;
        }

        @Override
        public boolean isTypeKnown() {
            return false;
        }

        @Override
        public boolean contains(PrimitiveType type) {
            for (PrimitiveType t : this.possibleTypes) {
                if (t != type) continue;
                return true;
            }
            return false;
        }

        @Override
        public ArgType selectFirst() {
            if (this.contains(PrimitiveType.OBJECT)) {
                return OBJECT;
            }
            if (this.contains(PrimitiveType.ARRAY)) {
                return UnknownArg.array(OBJECT);
            }
            return ArgType.primitive(this.possibleTypes[0]);
        }

        @Override
        boolean internalEquals(Object obj) {
            return Arrays.equals((Object[])this.possibleTypes, (Object[])((UnknownArg)obj).possibleTypes);
        }

        @Override
        public String toString() {
            if (this.possibleTypes.length == PrimitiveType.values().length) {
                return "?";
            }
            return "?[" + Utils.arrayToStr(this.possibleTypes) + ']';
        }
    }

    private static final class ArrayArg
    extends KnownType {
        private static final PrimitiveType[] ARRAY_POSSIBLES = new PrimitiveType[]{PrimitiveType.ARRAY};
        private final ArgType arrayElement;

        public ArrayArg(ArgType arrayElement) {
            this.arrayElement = arrayElement;
            this.hash = arrayElement.hashCode();
        }

        @Override
        public ArgType getArrayElement() {
            return this.arrayElement;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return PrimitiveType.ARRAY;
        }

        @Override
        public boolean isTypeKnown() {
            return this.arrayElement.isTypeKnown();
        }

        @Override
        public ArgType selectFirst() {
            return ArrayArg.array(this.arrayElement.selectFirst());
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return ARRAY_POSSIBLES;
        }

        @Override
        public int getArrayDimension() {
            return 1 + this.arrayElement.getArrayDimension();
        }

        @Override
        public ArgType getArrayRootElement() {
            return this.arrayElement.getArrayRootElement();
        }

        @Override
        boolean internalEquals(Object other) {
            ArrayArg otherArr = (ArrayArg)other;
            return this.arrayElement.equals(otherArr.getArrayElement());
        }

        @Override
        public String toString() {
            return this.arrayElement + "[]";
        }
    }

    private static class OuterGenericObject
    extends ObjectType {
        private final GenericObject outerType;
        private final ObjectType innerType;

        public OuterGenericObject(GenericObject outerType, ObjectType innerType) {
            super(outerType.getObject() + '$' + innerType.getObject());
            this.outerType = outerType;
            this.innerType = innerType;
            this.hash = this.calcHash();
        }

        private int calcHash() {
            return this.objName.hashCode() + 31 * (this.outerType.hashCode() + 31 * this.innerType.hashCode());
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public ArgType[] getGenericTypes() {
            return this.innerType.getGenericTypes();
        }

        @Override
        public ArgType getOuterType() {
            return this.outerType;
        }

        @Override
        public ArgType getInnerType() {
            return this.innerType;
        }

        @Override
        boolean internalEquals(Object obj) {
            return super.internalEquals(obj) && Objects.equals(this.outerType, ((OuterGenericObject)obj).outerType) && Objects.equals(this.innerType, ((OuterGenericObject)obj).innerType);
        }

        @Override
        public String toString() {
            return this.outerType.toString() + '$' + this.innerType.toString();
        }
    }

    private static class GenericObject
    extends ObjectType {
        private final ArgType[] generics;

        public GenericObject(String obj, ArgType[] generics) {
            super(obj);
            this.generics = Objects.requireNonNull(generics);
            this.hash = this.calcHash();
        }

        private int calcHash() {
            return this.objName.hashCode() + 31 * Arrays.hashCode(this.generics);
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public ArgType[] getGenericTypes() {
            return this.generics;
        }

        @Override
        boolean internalEquals(Object obj) {
            return super.internalEquals(obj) && Arrays.equals(this.generics, ((GenericObject)obj).generics);
        }

        @Override
        public String toString() {
            return super.toString() + '<' + Utils.arrayToStr(this.generics) + '>';
        }
    }

    private static final class WildcardType
    extends ObjectType {
        private final ArgType type;
        private final WildcardBound bound;

        public WildcardType(ArgType obj, WildcardBound bound) {
            super(OBJECT.getObject());
            this.type = Objects.requireNonNull(obj);
            this.bound = Objects.requireNonNull(bound);
        }

        @Override
        public boolean isGeneric() {
            return true;
        }

        @Override
        public ArgType getWildcardType() {
            return this.type;
        }

        @Override
        public WildcardBound getWildcardBound() {
            return this.bound;
        }

        @Override
        boolean internalEquals(Object obj) {
            return super.internalEquals(obj) && this.bound == ((WildcardType)obj).bound && this.type.equals(((WildcardType)obj).type);
        }

        @Override
        public String toString() {
            if (this.bound == WildcardBound.UNBOUND) {
                return this.bound.getStr();
            }
            return this.bound.getStr() + this.type;
        }
    }

    public static enum WildcardBound {
        EXTENDS(1, "? extends "),
        UNBOUND(0, "?"),
        SUPER(-1, "? super ");

        private final int num;
        private final String str;

        private WildcardBound(int val, String str) {
            this.num = val;
            this.str = str;
        }

        public int getNum() {
            return this.num;
        }

        public String getStr() {
            return this.str;
        }

        public static WildcardBound getByNum(int num) {
            return num == 0 ? UNBOUND : (num == 1 ? EXTENDS : SUPER);
        }
    }

    private static final class GenericType
    extends ObjectType {
        private List<ArgType> extendTypes;

        public GenericType(String obj) {
            super(obj);
        }

        @Override
        public boolean isGenericType() {
            return true;
        }

        @Override
        public List<ArgType> getExtendTypes() {
            return this.extendTypes;
        }

        @Override
        public void setExtendTypes(List<ArgType> extendTypes) {
            this.extendTypes = extendTypes;
        }
    }

    private static class ObjectType
    extends KnownType {
        protected final String objName;

        public ObjectType(String obj) {
            this.objName = Utils.cleanObjectName(obj);
            this.hash = this.objName.hashCode();
        }

        @Override
        public String getObject() {
            return this.objName;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return PrimitiveType.OBJECT;
        }

        @Override
        boolean internalEquals(Object obj) {
            return this.objName.equals(((ObjectType)obj).objName);
        }

        @Override
        public String toString() {
            return this.objName;
        }
    }

    private static final class PrimitiveArg
    extends KnownType {
        private final PrimitiveType type;

        public PrimitiveArg(PrimitiveType type) {
            this.type = type;
            this.hash = type.hashCode();
        }

        @Override
        public PrimitiveType getPrimitiveType() {
            return this.type;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        boolean internalEquals(Object obj) {
            return this.type == ((PrimitiveArg)obj).type;
        }

        @Override
        public String toString() {
            return this.type.toString();
        }
    }

    private static abstract class KnownType
    extends ArgType {
        private static final PrimitiveType[] EMPTY_POSSIBLES = new PrimitiveType[0];

        private KnownType() {
        }

        @Override
        public boolean isTypeKnown() {
            return true;
        }

        @Override
        public boolean contains(PrimitiveType type) {
            return this.getPrimitiveType() == type;
        }

        @Override
        public ArgType selectFirst() {
            return null;
        }

        @Override
        public PrimitiveType[] getPossibleTypes() {
            return EMPTY_POSSIBLES;
        }
    }
}

