/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IRegionVisitor;
import java.util.List;

public class CleanRegions
extends AbstractVisitor {
    private static final IRegionVisitor REMOVE_REGION_VISITOR = new RemoveRegionVisitor();

    @Override
    public void visit(MethodNode mth) {
        CleanRegions.process(mth);
    }

    public static void process(MethodNode mth) {
        if (mth.isNoCode() || mth.getBasicBlocks().isEmpty()) {
            return;
        }
        DepthRegionTraversal.traverse(mth, REMOVE_REGION_VISITOR);
    }

    private static class RemoveRegionVisitor
    extends AbstractRegionVisitor {
        private RemoveRegionVisitor() {
        }

        @Override
        public boolean enterRegion(MethodNode mth, IRegion region) {
            if (region instanceof Region) {
                region.getSubBlocks().removeIf(RemoveRegionVisitor::canRemoveRegion);
            }
            return true;
        }

        private static boolean canRemoveRegion(IContainer container) {
            if (container.contains(AFlag.DONT_GENERATE)) {
                return true;
            }
            if (container instanceof BlockNode) {
                BlockNode block = (BlockNode)container;
                return block.getInstructions().isEmpty();
            }
            if (container instanceof IRegion) {
                List<IContainer> subBlocks = ((IRegion)container).getSubBlocks();
                for (IContainer subBlock : subBlocks) {
                    if (RemoveRegionVisitor.canRemoveRegion(subBlock)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

