/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import com.headius.backport9.buffer.Buffers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRWriter;
import org.jruby.ir.persistence.IRWriterAnalyzer;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRWriterStream
implements IRWriterEncoder,
IRPersistenceValues {
    private final Map<IRScope, Integer> scopeInstructionOffsets = new HashMap<IRScope, Integer>();
    private final Map<IRScope, Integer> scopePoolOffsets = new HashMap<IRScope, Integer>();
    private final ByteBuffer buf = ByteBuffer.allocate(0x200000);
    private final OutputStream stream;
    private final IRWriterAnalyzer analyzer;
    private Map<RubySymbol, Integer> constantMap = new HashMap<RubySymbol, Integer>();
    int headersOffset = -1;

    public IRWriterStream(OutputStream stream) {
        this.stream = stream;
        this.analyzer = new IRWriterAnalyzer();
    }

    public IRWriterStream(File file2) throws FileNotFoundException {
        this(new FileOutputStream(file2));
    }

    public void addScopeInstructionOffset(IRScope scope) {
        this.scopeInstructionOffsets.put(scope, this.offset());
    }

    private int offset() {
        return this.buf.position() + 8;
    }

    public int getScopeInstructionOffset(IRScope scope) {
        return this.scopeInstructionOffsets.get(scope);
    }

    @Override
    public void encode(boolean value2) {
        this.buf.put(value2 ? (byte)116 : 102);
    }

    @Override
    public void encode(byte value2) {
        this.buf.put(value2);
    }

    @Override
    public void encode(char value2) {
        this.buf.putChar(value2);
    }

    @Override
    public void encode(int value2) {
        if (value2 >= 0 && value2 <= 127) {
            this.buf.put((byte)value2);
        } else {
            this.buf.put((byte)-1);
            this.buf.putInt(value2);
        }
    }

    @Override
    public void encode(int[] value2) {
        this.encode(value2.length);
        for (int i2 = 0; i2 < value2.length; ++i2) {
            this.encode(value2[i2]);
        }
    }

    @Override
    public void encode(long value2) {
        if (value2 >= 0L && value2 <= 127L) {
            this.encode((byte)value2);
        } else {
            this.buf.put((byte)-1);
            this.buf.putLong(value2);
        }
    }

    @Override
    public void encode(float value2) {
        this.buf.putFloat(value2);
    }

    @Override
    public void encode(double value2) {
        this.buf.putDouble(value2);
    }

    @Override
    public void encode(ByteList value2) {
        this.encode(value2.bytes());
        this.encode(value2.getEncoding());
    }

    @Override
    public void encode(byte[] bytes2) {
        this.encode(bytes2.length);
        this.buf.put(bytes2);
    }

    @Override
    public void encode(Encoding encoding2) {
        this.encode(encoding2.getName());
    }

    @Override
    public void encode(RubySymbol symbol) {
        Integer constantIndex = this.constantMap.get(symbol);
        if (constantIndex != null) {
            this.encode(constantIndex);
        } else {
            int index2 = this.constantMap.size();
            this.constantMap.put(symbol, index2);
            this.encode(index2);
        }
    }

    @Override
    public void encodeRaw(RubySymbol symbol) {
        if (symbol == null) {
            this.encode(-1);
        } else {
            this.encode(symbol.getBytes());
        }
    }

    @Override
    public void encode(String value2) {
        if (value2 == null) {
            this.encode(-1);
        } else {
            byte[] bytes2 = value2.getBytes();
            this.encode(bytes2.length);
            this.buf.put(bytes2);
        }
    }

    @Override
    public void encode(String[] values2) {
        if (values2 == null) {
            this.encode(0);
            return;
        }
        this.encode(values2.length);
        for (String value2 : values2) {
            this.encode(value2.length());
            this.buf.put(value2.getBytes());
        }
    }

    @Override
    public void encode(Operand operand) {
        operand.encode(this);
    }

    @Override
    public void encode(Operand[] operands) {
        this.encode(operands.length);
        for (Operand arg2 : operands) {
            this.encode(arg2);
        }
    }

    @Override
    public void encode(Instr instr) {
        instr.encode(this);
    }

    @Override
    public void encode(IRScope value2) {
        this.encode(this.analyzer.getScopeID(value2));
    }

    @Override
    public void encode(IRScopeType value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void encode(Signature signature) {
        if (signature == null) {
            signature = Signature.NO_ARGUMENTS;
        }
        this.encode(signature.encode());
    }

    @Override
    public void encode(RubyEvent event2) {
        this.encode((byte)event2.ordinal());
    }

    @Override
    public void encode(StaticScope.Type value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void encode(Operation value2) {
        this.encode(value2.ordinal());
    }

    @Override
    public void encode(OperandType value2) {
        this.encode((byte)value2.ordinal());
    }

    @Override
    public void startEncodingScopeHeader(IRScope scope) {
    }

    @Override
    public void endEncodingScopeHeader(IRScope scope) {
        this.encode(this.getScopeInstructionOffset(scope));
        this.encode(this.scopePoolOffsets.get(scope));
    }

    @Override
    public void startEncodingScopeInstrs(IRScope scope) {
        this.constantMap.clear();
        this.addScopeInstructionOffset(scope);
        this.encode(scope.getInterpreterContext().getInstructions().length);
    }

    @Override
    public void endEncodingScopeInstrs(IRScope scope) {
        this.scopePoolOffsets.put(scope, this.offset());
        LinkedList<Map.Entry<RubySymbol, Integer>> list2 = new LinkedList<Map.Entry<RubySymbol, Integer>>(this.constantMap.entrySet());
        Collections.sort(list2, Comparator.comparing(Map.Entry::getValue));
        this.encode(list2.size());
        for (Map.Entry entry : list2) {
            this.encodeRaw((RubySymbol)entry.getKey());
        }
    }

    @Override
    public void startEncodingScopeHeaders(IRScope script) {
        this.headersOffset = this.offset();
        this.encode(this.analyzer.getScopeCount());
    }

    @Override
    public void endEncodingScopeHeaders(IRScope script) {
    }

    @Override
    public void startEncoding(IRScope script) {
        try {
            IRWriter.persist(this.analyzer, script);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void endEncoding(IRScope script) {
        try {
            this.stream.write(ByteBuffer.allocate(4).putInt(2).array());
            this.stream.write(ByteBuffer.allocate(4).putInt(this.headersOffset).array());
            Buffers.flipBuffer(this.buf);
            this.stream.write(this.buf.array(), this.buf.position(), this.buf.limit());
            this.stream.close();
        }
        catch (IOException e) {
            try {
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

