"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../state/utils");
var commons_1 = require("../../../utils/commons");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
var tooltip_1 = require("../tooltip/tooltip");
var geometry_1 = require("../../../utils/geometry");
function getPostfix(spec) {
    if (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec)) {
        var _a = spec.y0AccessorFormat, y0AccessorFormat = _a === void 0 ? tooltip_1.Y0_ACCESSOR_POSTFIX : _a, _b = spec.y1AccessorFormat, y1AccessorFormat = _b === void 0 ? tooltip_1.Y1_ACCESSOR_POSTFIX : _b;
        return {
            y0AccessorFormat: y0AccessorFormat,
            y1AccessorFormat: y1AccessorFormat,
        };
    }
    return {};
}
function getItemLabel(_a, yAccessor) {
    var banded = _a.banded, label = _a.label, y1AccessorFormat = _a.y1AccessorFormat, y0AccessorFormat = _a.y0AccessorFormat;
    if (!banded) {
        return label;
    }
    return yAccessor === geometry_1.BandedAccessorType.Y1 ? "" + label + y1AccessorFormat : "" + label + y0AccessorFormat;
}
exports.getItemLabel = getItemLabel;
function computeLegend(seriesCollection, seriesColors, specs, defaultColor, axesSpecs, deselectedDataSeries) {
    if (deselectedDataSeries === void 0) { deselectedDataSeries = []; }
    var legendItems = new Map();
    var sortedCollection = series_1.getSortedDataSeriesColorsValuesMap(seriesCollection);
    sortedCollection.forEach(function (series, key) {
        var banded = series.banded, lastValue = series.lastValue, seriesIdentifier = series.seriesIdentifier;
        var spec = utils_1.getSpecsById(specs, seriesIdentifier.specId);
        var color = seriesColors.get(key) || defaultColor;
        var hasSingleSeries = seriesCollection.size === 1;
        var label = series_1.getSeriesLabel(seriesIdentifier, hasSingleSeries, false, spec);
        var isSeriesVisible = deselectedDataSeries ? series_1.getSeriesIndex(deselectedDataSeries, seriesIdentifier) < 0 : true;
        if (label === '' || !spec) {
            return;
        }
        // Use this to get axis spec w/ tick formatter
        var yAxis = utils_1.getAxesSpecForSpecId(axesSpecs, spec.groupId).yAxis;
        var formatter = yAxis ? yAxis.tickFormat : commons_1.identity;
        var hideInLegend = spec.hideInLegend;
        var legendItem = __assign({ key: key,
            color: color,
            label: label,
            banded: banded,
            seriesIdentifier: seriesIdentifier,
            isSeriesVisible: isSeriesVisible, isLegendItemVisible: !hideInLegend, displayValue: {
                raw: {
                    y0: lastValue && lastValue.y0 !== null ? lastValue.y0 : null,
                    y1: lastValue && lastValue.y1 !== null ? lastValue.y1 : null,
                },
                formatted: {
                    y0: lastValue && lastValue.y0 !== null ? formatter(lastValue.y0) : null,
                    y1: lastValue && lastValue.y1 !== null ? formatter(lastValue.y1) : null,
                },
            } }, getPostfix(spec));
        legendItems.set(key, legendItem);
    });
    return legendItems;
}
exports.computeLegend = computeLegend;
//# sourceMappingURL=legend.js.map