"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var geometry_1 = require("../../../utils/geometry");
/** The type of tooltip to use */
exports.TooltipType = Object.freeze({
    /** Vertical cursor parallel to x axis */
    VerticalCursor: 'vertical',
    /** Vertical and horizontal cursors */
    Crosshairs: 'cross',
    /** Follor the mouse coordinates */
    Follow: 'follow',
    /** Hide every tooltip */
    None: 'none',
});
/**
 * Get the cursor position depending on the chart rotation
 * @param xPos x position relative to chart
 * @param yPos y position relative to chart
 * @param chartRotation the chart rotation
 * @param chartDimension the chart dimension
 */
function getOrientedXPosition(xPos, yPos, chartRotation, chartDimension) {
    switch (chartRotation) {
        case 0:
            return xPos;
        case 180:
            return chartDimension.width - xPos;
        case 90:
            return yPos;
        case -90:
            return chartDimension.height - yPos;
    }
}
exports.getOrientedXPosition = getOrientedXPosition;
function getOrientedYPosition(xPos, yPos, chartRotation, chartDimension) {
    switch (chartRotation) {
        case 0:
            return yPos;
        case 180:
            return chartDimension.height - yPos;
        case -90:
            return xPos;
        case 90:
            return chartDimension.width - xPos;
    }
}
exports.getOrientedYPosition = getOrientedYPosition;
function isCrosshairTooltipType(type) {
    return type === exports.TooltipType.VerticalCursor || type === exports.TooltipType.Crosshairs;
}
exports.isCrosshairTooltipType = isCrosshairTooltipType;
function isFollowTooltipType(type) {
    return type === exports.TooltipType.Follow;
}
exports.isFollowTooltipType = isFollowTooltipType;
function areIndexedGeometryArraysEquals(arr1, arr2) {
    if (arr1.length !== arr2.length) {
        return false;
    }
    for (var i = arr1.length; i--;) {
        return areIndexedGeomsEquals(arr1[i], arr2[i]);
    }
    return true;
}
exports.areIndexedGeometryArraysEquals = areIndexedGeometryArraysEquals;
function areIndexedGeomsEquals(ig1, ig2) {
    if (geometry_1.isPointGeometry(ig1) && geometry_1.isPointGeometry(ig2)) {
        return arePointsEqual(ig1, ig2);
    }
    if (geometry_1.isBarGeometry(ig1) && geometry_1.isBarGeometry(ig2)) {
        return areBarEqual(ig1, ig2);
    }
    return false;
}
exports.areIndexedGeomsEquals = areIndexedGeomsEquals;
function arePointsEqual(ig1, ig2) {
    return (ig1.seriesIdentifier.specId === ig2.seriesIdentifier.specId &&
        ig1.color === ig2.color &&
        ig1.x === ig2.x &&
        ig1.transform.x === ig2.transform.x &&
        ig1.transform.y === ig2.transform.y &&
        ig1.y === ig2.y &&
        ig1.radius === ig2.radius);
}
function areBarEqual(ig1, ig2) {
    return (ig1.seriesIdentifier.specId === ig2.seriesIdentifier.specId &&
        ig1.color === ig2.color &&
        ig1.x === ig2.x &&
        ig1.y === ig2.y &&
        ig1.width === ig2.width &&
        ig1.height === ig2.height);
}
function isTooltipProps(config) {
    return typeof config === 'object';
}
exports.isTooltipProps = isTooltipProps;
function isTooltipType(config) {
    return typeof config === 'string';
}
exports.isTooltipType = isTooltipType;
//# sourceMappingURL=interactions.js.map