"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var fast_deep_equal_1 = require("../../utils/fast_deep_equal");
var icon_1 = require("../icons/icon");
/**
 * Create a div for the the displayed value
 * @param displayValue
 * @param isSeriesVisible
 */
function renderDisplayValue(displayValue, isSeriesVisible) {
    var _a;
    var displayValueClassNames = classnames_1.default('echLegendItem__displayValue', (_a = {},
        _a['echLegendItem__displayValue--hidden'] = !isSeriesVisible,
        _a));
    return (react_1.default.createElement("div", { className: displayValueClassNames, title: displayValue }, displayValue));
}
/**
 * Create a div for the title
 * @param title
 * @param onTitleClick
 * @param hasTitleClickListener
 * @param isSelected
 * @param showLegendDisplayValue
 */
function renderTitle(title, onTitleClick, hasTitleClickListener, isSelected, showLegendDisplayValue) {
    var _a;
    // TODO add contextual menu panel on click
    var titleClassNames = classnames_1.default('echLegendItem__title', (_a = {},
        _a['echLegendItem__title--hasClickListener'] = hasTitleClickListener,
        _a['echLegendItem__title--selected'] = isSelected,
        _a['echLegendItem__title--hasDisplayValue'] = showLegendDisplayValue,
        _a));
    return (react_1.default.createElement("div", { className: titleClassNames, title: title, onClick: onTitleClick }, title));
}
/**
 * Create a div for the color/eye icon
 * @param color
 * @param isSeriesVisible
 */
function renderColor(color, isSeriesVisible) {
    if (isSeriesVisible === void 0) { isSeriesVisible = true; }
    // TODO add color picker
    if (isSeriesVisible) {
        return (react_1.default.createElement("div", { className: "echLegendItem__color", "aria-label": "series color", title: "series color" },
            react_1.default.createElement(icon_1.Icon, { type: "dot", color: color })));
    }
    // changing the default viewBox for the eyeClosed icon to keep the same dimensions
    return (react_1.default.createElement("div", { className: "echLegendItem__color", "aria-label": "series hidden", title: "series hidden" },
        react_1.default.createElement(icon_1.Icon, { type: "eyeClosed", viewBox: "-3 -3 22 22" })));
}
var LegendListItem = /** @class */ (function (_super) {
    __extends(LegendListItem, _super);
    function LegendListItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onLegendItemMouseOver = function () {
            var _a = _this.props, onLegendItemOverListener = _a.onLegendItemOverListener, legendItemOverAction = _a.legendItemOverAction, legendItem = _a.legendItem;
            // call the settings listener directly if available
            if (onLegendItemOverListener) {
                onLegendItemOverListener(legendItem.seriesIdentifier);
            }
            legendItemOverAction(legendItem.key);
        };
        _this.onLegendItemMouseOut = function () {
            var _a = _this.props, onLegendItemOutListener = _a.onLegendItemOutListener, legendItemOutAction = _a.legendItemOutAction;
            // call the settings listener directly if available
            if (onLegendItemOutListener) {
                onLegendItemOutListener();
            }
            legendItemOutAction();
        };
        // TODO handle shift key
        _this.onVisibilityClick = function (legendItemId) { return function () {
            var _a = _this.props, onLegendItemClickListener = _a.onLegendItemClickListener, toggleDeselectSeriesAction = _a.toggleDeselectSeriesAction;
            if (onLegendItemClickListener) {
                onLegendItemClickListener(legendItemId);
            }
            toggleDeselectSeriesAction(legendItemId);
        }; };
        return _this;
    }
    LegendListItem.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    LegendListItem.prototype.render = function () {
        var _a = this.props, displayValue = _a.displayValue, legendItem = _a.legendItem, legendPosition = _a.legendPosition, label = _a.label;
        var color = legendItem.color, isSeriesVisible = legendItem.isSeriesVisible, seriesIdentifier = legendItem.seriesIdentifier, isLegendItemVisible = legendItem.isLegendItemVisible;
        var onTitleClick = this.onVisibilityClick(seriesIdentifier);
        var _b = this.props, showLegendDisplayValue = _b.showLegendDisplayValue, selectedLegendItem = _b.selectedLegendItem, onLegendItemClickListener = _b.onLegendItemClickListener;
        var isSelected = selectedLegendItem == null ? false : selectedLegendItem.seriesIdentifier.key === seriesIdentifier.key;
        var hasTitleClickListener = Boolean(onLegendItemClickListener);
        var itemClasses = classnames_1.default('echLegendItem', "echLegendItem--" + legendPosition, {
            'echLegendItem-isHidden': !isSeriesVisible,
            'echLegendItem__displayValue--hidden': !isLegendItemVisible,
        });
        return (react_1.default.createElement("div", { className: itemClasses, onMouseEnter: this.onLegendItemMouseOver, onMouseLeave: this.onLegendItemMouseOut },
            color && renderColor(color, isSeriesVisible),
            label && renderTitle(label, onTitleClick, hasTitleClickListener, isSelected, showLegendDisplayValue),
            showLegendDisplayValue && renderDisplayValue(displayValue, isSeriesVisible)));
    };
    LegendListItem.displayName = 'LegendItem';
    return LegendListItem;
}(react_1.default.Component));
exports.LegendListItem = LegendListItem;
//# sourceMappingURL=legend_item.js.map