import ascending from "./ascending";

export default function scan(values, compare = ascending) {
  let min;
  let minIndex;
  let index = -1;
  for (const value of values) {
    ++index;
    if (minIndex === undefined
        ? compare(value, value) === 0
        : compare(value, min) < 0) {
      min = value;
      minIndex = index;
    }
  }
  return minIndex;
}
