# Config file for nepomuk-core. Do not modify this file. Any change will be overwritten by CMake.

# This file will define the following variables:
#
# NEPOMUK_CORE_LIB_DIR : The nepomuk-core library directory
# NEPOMUK_CORE_INCLUDE_DIR : The nepomuk-core include directory
# NEPOMUK_CORE_VERSION : The nepomuk-core version
# NEPOMUK_CORE_ONTOLOGY_DIR : The nepomuk-core ontologies location
# NEPOMUK_CORE_DBUS_INTERFACES_DIR : The nepomuk-core DBUS Interfaces dir
# NEPOMUK_CORE_LIBRARY : The nepomukcore library

get_filename_component(_currentDir ${CMAKE_CURRENT_LIST_FILE} PATH) # The current directory
get_filename_component(rootDir ${_currentDir}/ ABSOLUTE) # The install prefix

# The nepomuk-core version
set(NEPOMUK_CORE_VERSION_MAJOR 4)
set(NEPOMUK_CORE_VERSION_MINOR 14)
set(NEPOMUK_CORE_VERSION_RELEASE 10)
set(NEPOMUK_CORE_VERSION ${NEPOMUK_CORE_VERSION_MAJOR}.${NEPOMUK_CORE_VERSION_MINOR}.${NEPOMUK_CORE_VERSION_RELEASE})

# set the directories
if(NOT NEPOMUK_CORE_INSTALL_DIR)
   set(NEPOMUK_CORE_INSTALL_DIR "/usr/local")
endif()

# Include directory
set(NEPOMUK_CORE_INCLUDE_DIR "${CMAKE_INSTALL_PREFIX}/include/kde4")

# Library directory
set(NEPOMUK_CORE_LIB_DIR "/usr/local/lib")

# Ontologies location
set(NEPOMUK_CORE_ONTOLOGY_DIR "/usr/local/share/ontology")

# DBUS Interfaces location
set(NEPOMUK_CORE_DBUS_INTERFACES_DIR "/usr/local/share/dbus-1/interfaces")

# Import the exported targets
if(NOT TARGET nepomukcore)
  include(${_currentDir}/NepomukCoreTargetsWithPrefix.cmake)
endif()

# Set the libraries names
set(NEPOMUK_CORE_LIBRARY nepomukcore)

find_file(NEPOMUK2_ADDONTOLOGYCLASSES_FILE Nepomuk2AddOntologyClasses.cmake
          PATH ${_currentDir}
         )

if(NOT NEPOMUK2_ADDONTOLOGYCLASSES_FILE)
  message(STATUS "Could not find Nepomuk2AddOntologyClasses.cmake")
else()
  include("${NEPOMUK2_ADDONTOLOGYCLASSES_FILE}")
endif()

