/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf)) => dmat4x2(0.16lf, -1.69lf, -0.8lf, 0.59lf, -1.74lf, -1.43lf, -0.02lf, -1.21lf)
 * transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf)) => dmat4x2(-1.02lf, 0.74lf, -1.64lf, -0.13lf, -1.59lf, 0.47lf, 0.3lf, 1.13lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec2(0.16lf, -1.69lf)) * distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[0], dvec2(0.16lf, -1.69lf))) + (distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec2(-0.8lf, 0.59lf)) * distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[1], dvec2(-0.8lf, 0.59lf))) + (distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[2], dvec2(-1.74lf, -1.43lf)) * distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[2], dvec2(-1.74lf, -1.43lf))) + (distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[3], dvec2(-0.02lf, -1.21lf)) * distance(transpose(dmat2x4(0.16lf, -0.8lf, -1.74lf, -0.02lf, -1.69lf, 0.59lf, -1.43lf, -1.21lf))[3], dvec2(-0.02lf, -1.21lf))) <= 1.04068e-09lf ? 1 : -1] array0;
  double[(distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec2(-1.02lf, 0.74lf)) * distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[0], dvec2(-1.02lf, 0.74lf))) + (distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec2(-1.64lf, -0.13lf)) * distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[1], dvec2(-1.64lf, -0.13lf))) + (distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[2], dvec2(-1.59lf, 0.47lf)) * distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[2], dvec2(-1.59lf, 0.47lf))) + (distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[3], dvec2(0.3lf, 1.13lf)) * distance(transpose(dmat2x4(-1.02lf, -1.64lf, -1.59lf, 0.3lf, 0.74lf, -0.13lf, 0.47lf, 1.13lf))[3], dvec2(0.3lf, 1.13lf))) <= 8.410400000000001e-10lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
