/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) / -1.33) => vec2(0.075187966, 0.90225565)
 * (vec2(-0.1, -1.2) / 0.85) => vec2(-0.11764706, -1.4117647)
 * (vec2(-0.42, 0.48) / -1.33) => vec2(0.31578946, -0.36090225)
 * (vec2(-0.42, 0.48) / 0.85) => vec2(-0.49411762, 0.56470585)
 */
#version 120

void main()
{
  float[distance((vec2(-0.1, -1.2) / -1.33), vec2(0.075187966, 0.90225565)) <= 9.053831e-06 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) / 0.85), vec2(-0.11764706, -1.4117647)) <= 1.4166582e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.42, 0.48) / -1.33), vec2(0.31578946, -0.36090225)) <= 4.795554e-06 ? 1 : -1] array2;
  float[distance((vec2(-0.42, 0.48) / 0.85), vec2(-0.49411762, 0.56470585)) <= 7.503632e-06 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
