/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.SmartEnterUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.EnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.PyCommentBreakerEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.PyPlainEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.GoogleDocStringSectionFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyArgumentListFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyClassFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyConditionalStatementPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyExceptFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyForPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFunctionFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyMissingBracesFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyParameterListFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyParenthesizedFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyStringLiteralFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyUnconditionalStatementPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyWithFixer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(PySmartEnterProcessor.class);
    private static final List<PyFixer> ourFixers = ImmutableList.builder().add((Object)new PyStringLiteralFixer()).add((Object)new GoogleDocStringSectionFixer()).add((Object)new PyParenthesizedFixer()).add((Object)new PyMissingBracesFixer()).add((Object)new PyConditionalStatementPartFixer()).add((Object)new PyUnconditionalStatementPartFixer()).add((Object)new PyForPartFixer()).add((Object)new PyExceptFixer()).add((Object)new PyArgumentListFixer()).add((Object)new PyParameterListFixer()).add((Object)new PyFunctionFixer()).add((Object)new PyClassFixer()).add((Object)new PyWithFixer()).build();
    private static final List<EnterProcessor> ourProcessors = ImmutableList.of((Object)new PyCommentBreakerEnterProcessor(), (Object)new PyPlainEnterProcessor());
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");

    private static void collectAllElements(PsiElement element, @NotNull List<PsiElement> result, boolean recurse) {
        PsiElement[] children2;
        if (result == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(0);
        }
        result.add(0, element);
        if (PySmartEnterProcessor.doNotStep(element)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children2 = element.getChildren()) {
            if (element instanceof PyStatement && child instanceof PyStatement) continue;
            PySmartEnterProcessor.collectAllElements(child, result, recurse);
        }
    }

    private static boolean doNotStep(PsiElement element) {
        return element instanceof PyStatementList || element instanceof PyStatement;
    }

    private static boolean isModified(@NotNull Editor editor2) {
        if (editor2 == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(1);
        }
        Long timestamp = (Long)editor2.getUserData(SMART_ENTER_TIMESTAMP);
        return editor2.getDocument().getModificationStamp() != timestamp.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (project == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(4);
        }
        Document document = editor2.getDocument();
        String textForRollBack = document.getText();
        int offset = editor2.getCaretModel().getOffset();
        try {
            editor2.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor2.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor2, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            LOG.info((Throwable)e);
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollBack);
            editor2.getCaretModel().moveToOffset(offset);
        }
        finally {
            editor2.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            PySmartEnterProcessor.$$$reportNull$$$0(7);
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            PsiElement statementAtCaret;
            this.commit(editor2);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            if ((statementAtCaret = this.getStatementAtCaret(editor2, psiFile)) == null) {
                if (!new PyCommentBreakerEnterProcessor().doEnter(editor2, (PsiElement)psiFile, false)) {
                    SmartEnterUtil.plainEnter(editor2);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            PySmartEnterProcessor.collectAllElements(statementAtCaret, queue, true);
            queue.add(statementAtCaret);
            for (PsiElement element : queue) {
                for (PyFixer fixer : ourFixers) {
                    fixer.apply(editor2, this, element);
                    if (LookupManager.getInstance((Project)project).getActiveLookup() != null) {
                        return;
                    }
                    PyPsiUtils.assertValid(element);
                    if (!PySmartEnterProcessor.isUncommited((Project)project) && element.isValid()) continue;
                    this.process(project, editor2, psiFile, attempt + 1);
                    return;
                }
            }
            this.doEnter(statementAtCaret, editor2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void doEnter(PsiElement atCaret, Editor editor2) {
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            return;
        }
        this.commit(editor2);
        for (EnterProcessor enterProcessor : ourProcessors) {
            if (!enterProcessor.doEnter(editor2, atCaret, PySmartEnterProcessor.isModified(editor2))) continue;
            return;
        }
        if (!PySmartEnterProcessor.isModified(editor2)) {
            SmartEnterUtil.plainEnter(editor2);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor2.getCaretModel().moveToOffset(atCaret.getTextRange().getEndOffset());
        } else {
            editor2.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor2, PsiFile psiFile) {
        block5: {
            PsiElement statementAtCaret;
            block4: {
                statementAtCaret = super.getStatementAtCaret(editor2, psiFile);
                if (statementAtCaret instanceof PsiWhiteSpace) {
                    return null;
                }
                if (statementAtCaret == null) {
                    return null;
                }
                PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementAtCaret, PyStatementList.class, (boolean)false);
                if (statementList == null) break block4;
                for (PyStatement statement : statementList.getStatements()) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statementAtCaret, (boolean)true)) continue;
                    return statement;
                }
                break block5;
            }
            PyFile file = (PyFile)PsiTreeUtil.getParentOfType((PsiElement)statementAtCaret, PyFile.class, (boolean)false);
            if (file == null) break block5;
            for (PyStatement statement : file.getStatements()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statementAtCaret, (boolean)true)) continue;
                return statement;
            }
        }
        return null;
    }

    public void registerUnresolvedError(int offset) {
        if (offset < this.myFirstErrorOffset) {
            this.myFirstErrorOffset = offset;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAllElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TooManyAttemptsException
    extends Exception {
        private TooManyAttemptsException() {
        }
    }
}

