/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyPrefixExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDemorganIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.demorgan.law", new Object[0]);
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        PyElementType op;
        if (project == null) {
            PyDemorganIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyBinaryExpression expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyBinaryExpression.class);
        return expression != null && ((op = expression.getOperator()) == PyTokenTypes.AND_KEYWORD || op == PyTokenTypes.OR_KEYWORD);
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyDemorganIntention.$$$reportNull$$$0(3);
        }
        PyBinaryExpression expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor2.getCaretModel().getOffset()), PyBinaryExpression.class);
        assert (expression != null);
        PyElementType op = expression.getOperator();
        assert (op != null);
        String converted = PyDemorganIntention.convertConjunctionExpression(expression, op);
        PyDemorganIntention.replaceExpression(converted, expression);
    }

    private static void replaceExpression(String newExpression, PyBinaryExpression expression) {
        PyBinaryExpression expressionToReplace = expression;
        String expString = "not(" + newExpression + ')';
        PsiElement parent = expression.getParent().getParent();
        if (PyDemorganIntention.isNegation(parent)) {
            expressionToReplace = parent;
            expString = newExpression;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(expression.getProject());
        PyExpression newCall = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), expString);
        expressionToReplace.replace((PsiElement)newCall);
    }

    @NotNull
    private static String convertConjunctionExpression(@NotNull PyBinaryExpression exp, @NotNull PyElementType tokenType) {
        PyExpression lhs;
        if (exp == null) {
            PyDemorganIntention.$$$reportNull$$$0(4);
        }
        if (tokenType == null) {
            PyDemorganIntention.$$$reportNull$$$0(5);
        }
        String lhsText = PyDemorganIntention.isConjunctionExpression(lhs = exp.getLeftExpression(), tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)lhs, tokenType) : PyDemorganIntention.convertLeafExpression(lhs);
        PyExpression rhs = exp.getRightExpression();
        String rhsText = PyDemorganIntention.isConjunctionExpression(rhs, tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)rhs, tokenType) : PyDemorganIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType == PyTokenTypes.AND_KEYWORD ? " or " : " and ";
        String string = lhsText + flippedConjunction + rhsText;
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String convertLeafExpression(@Nullable PyExpression condition) {
        if (condition == null) {
            return "";
        }
        if (PyDemorganIntention.isNegation((PsiElement)condition)) {
            PyExpression negated = PyDemorganIntention.getNegated(condition);
            if (negated == null) {
                return "";
            }
            String string = negated.getText();
            if (string == null) {
                PyDemorganIntention.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (condition instanceof PyBinaryExpression) {
            String string = "not(" + condition.getText() + ")";
            if (string == null) {
                PyDemorganIntention.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = "not " + condition.getText();
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PyExpression getNegated(@NotNull PyExpression expression) {
        if (expression == null) {
            PyDemorganIntention.$$$reportNull$$$0(10);
        }
        return ((PyPrefixExpression)expression).getOperand();
    }

    private static boolean isConjunctionExpression(@Nullable PyExpression expression, @NotNull PyElementType tokenType) {
        if (tokenType == null) {
            PyDemorganIntention.$$$reportNull$$$0(11);
        }
        if (expression instanceof PyBinaryExpression) {
            PyElementType operator = ((PyBinaryExpression)expression).getOperator();
            return operator == tokenType;
        }
        return false;
    }

    private static boolean isNegation(@Nullable PsiElement expression) {
        if (!(expression instanceof PyPrefixExpression)) {
            return false;
        }
        PyElementType op = ((PyPrefixExpression)expression).getOperator();
        return op == PyTokenTypes.NOT_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertConjunctionExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLeafExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertConjunctionExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNegated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConjunctionExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

