/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.base.Preconditions;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyGenerateDocstringIntention;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecifyTypeInDocstringIntention
extends TypeIntention {
    private String myText = PyBundle.message("INTN.specify.type", new Object[0]);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.specify.type", new Object[0]);
        if (string == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PyNamedParameter parameter;
        if (project == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(2);
        }
        if ((parameter = this.findOnlySuitableParameter(editor2, file)) != null) {
            PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
            if (parentFunction != null) {
                SpecifyTypeInDocstringIntention.generateDocstring(parameter, parentFunction);
            }
            return;
        }
        PyFunction function = this.findOnlySuitableFunction(editor2, file);
        if (function != null) {
            SpecifyTypeInDocstringIntention.generateDocstring(null, function);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void generateDocstring(@Nullable PyNamedParameter param, @NotNull PyFunction pyFunction) {
        if (pyFunction == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pyFunction)) {
            return;
        }
        if (!PyGenerateDocstringIntention.ensureNotPlainDocstringFormat(pyFunction)) {
            return;
        }
        PyDocstringGenerator docstringGenerator = PyDocstringGenerator.forDocStringOwner(pyFunction);
        String type = "object";
        if (param != null) {
            String paramName = StringUtil.notNullize((String)param.getName());
            PySignature signature = PySignatureCacheManager.getInstance(pyFunction.getProject()).findSignature(pyFunction);
            if (signature != null) {
                type = (String)ObjectUtils.chooseNotNull((Object)signature.getArgTypeQualifiedName(paramName), (Object)type);
            }
            docstringGenerator.withParamTypedByName(param, type);
        } else {
            PySignature signature = PySignatureCacheManager.getInstance(pyFunction.getProject()).findSignature(pyFunction);
            if (signature != null) {
                type = (String)ObjectUtils.chooseNotNull((Object)signature.getReturnTypeQualifiedName(), (Object)type);
            }
            docstringGenerator.withReturnValue(type);
        }
        WriteAction.run(() -> {
            docstringGenerator.addFirstEmptyLine().buildAndInsert();
            SpecifyTypeInDocstringIntention.startTemplate(docstringGenerator);
        });
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.myText = PyBundle.message(isReturn ? "INTN.specify.return.type" : "INTN.specify.type", new Object[0]);
    }

    @Override
    protected boolean isParamTypeDefined(@NotNull PyNamedParameter parameter) {
        PyFunction pyFunction;
        if (parameter == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(4);
        }
        if ((pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class)) != null) {
            StructuredDocString structuredDocString = pyFunction.getStructuredDocString();
            if (structuredDocString == null) {
                return false;
            }
            Substring typeSub = structuredDocString.getParamTypeSubstring(StringUtil.notNullize((String)parameter.getName()));
            return typeSub != null && !typeSub.isEmpty();
        }
        return false;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        StructuredDocString structuredDocString;
        if (function == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(5);
        }
        return (structuredDocString = function.getStructuredDocString()) != null && structuredDocString.getReturnType() != null;
    }

    public static void startTemplate(PyDocstringGenerator generator) {
        Substring substring;
        Preconditions.checkNotNull((Object)generator.getDocStringOwner(), (Object)"For this action docstring owner must be supplied");
        PyStringLiteralExpression docStringExpression = generator.getDocStringExpression();
        assert (docStringExpression != null);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)docStringExpression);
        if (generator.getAddedParams().size() > 1) {
            throw new IllegalArgumentException("TemplateBuilder can be created only for one parameter");
        }
        PyDocstringGenerator.DocstringParam paramToEdit = generator.getParamToEdit();
        DocStringFormat format = generator.getDocStringFormat();
        if (format == DocStringFormat.PLAIN) {
            return;
        }
        StructuredDocString parsed = DocStringUtil.parseDocString(format, docStringExpression);
        if (paramToEdit.isReturnValue()) {
            substring = parsed.getReturnTypeSubstring();
        } else {
            String paramName = paramToEdit.getName();
            substring = parsed.getParamTypeSubstring(paramName);
        }
        if (substring == null) {
            return;
        }
        builder.replaceRange(substring.getTextRange(), PyDocstringGenerator.getDefaultType(generator.getParamToEdit()));
        Template template = (Template)PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)generator.getDocStringOwner(), document -> ((TemplateBuilderImpl)builder).buildInlineTemplate());
        VirtualFile virtualFile = generator.getDocStringOwner().getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = generator.getDocStringOwner().getProject();
        Editor targetEditor = PsiEditorUtil.findEditor((PsiElement)generator.getDocStringOwner());
        if (targetEditor != null && template != null) {
            targetEditor.getCaretModel().moveToOffset(docStringExpression.getTextOffset());
            TemplateManager.getInstance((Project)project).startTemplate(targetEditor, template);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateDocstring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isParamTypeDefined";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

