/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.parsing.console.PyConsoleHighlightingLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private final Map<LanguageLevel, PyHighlighter> myMap = FactoryMap.create(key -> new PyHighlighter((LanguageLevel)((Object)key)));
    private final Map<LanguageLevel, PyHighlighter> myConsoleMap = FactoryMap.create(key -> new PyHighlighter((LanguageLevel)((Object)key)){

        @Override
        protected PythonHighlightingLexer createHighlightingLexer(LanguageLevel languageLevel) {
            return new PyConsoleHighlightingLexer(languageLevel);
        }
    });

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel level = PySyntaxHighlighterFactory.getLanguageLevel(project, virtualFile);
        if (PySyntaxHighlighterFactory.useConsoleLexer(project, virtualFile)) {
            SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myConsoleMap.get((Object)level);
            if (syntaxHighlighter == null) {
                PySyntaxHighlighterFactory.$$$reportNull$$$0(0);
            }
            return syntaxHighlighter;
        }
        SyntaxHighlighter syntaxHighlighter = this.getSyntaxHighlighterForLanguageLevel(level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactory.$$$reportNull$$$0(1);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public SyntaxHighlighter getConsoleSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel level = PySyntaxHighlighterFactory.getLanguageLevel(project, virtualFile);
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myConsoleMap.get((Object)level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactory.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighterForLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            PySyntaxHighlighterFactory.$$$reportNull$$$0(3);
        }
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myMap.get((Object)level);
        if (syntaxHighlighter == null) {
            PySyntaxHighlighterFactory.$$$reportNull$$$0(4);
        }
        return syntaxHighlighter;
    }

    @NotNull
    private static LanguageLevel getLanguageLevel(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel = project != null && virtualFile != null ? PyUtil.getLanguageLevelForVirtualFile(project, virtualFile) : LanguageLevel.getDefault();
        if (languageLevel == null) {
            PySyntaxHighlighterFactory.$$$reportNull$$$0(5);
        }
        return languageLevel;
    }

    private static boolean useConsoleLexer(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null || project == null || virtualFile instanceof VirtualFileWindow) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        return psiFile != null && PydevConsoleRunner.isInPydevConsole((PsiElement)psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/highlighting/PySyntaxHighlighterFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleSyntaxHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/highlighting/PySyntaxHighlighterFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighterForLanguageLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSyntaxHighlighterForLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

