/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyAddPropertyForFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMakePublicQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.testing.PyTestsSharedKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyProtectedMemberInspection
extends PyInspection {
    public boolean ignoreTestFunctions = true;
    public boolean ignoreAnnotations = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyProtectedMemberInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyProtectedMemberInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(PyBundle.message("INSP.protected.member.ignore.test.functions", new Object[0]), "ignoreTestFunctions");
        panel2.addCheckbox(PyBundle.message("INSP.protected.member.ignore.annotations", new Object[0]), "ignoreAnnotations");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyProtectedMemberInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            PyStatement statement = node.getContainingImportStatement();
            if (!(statement instanceof PyFromImportStatement)) {
                return;
            }
            PyReferenceExpression importReferenceExpression = node.getImportReferenceExpression();
            PyReferenceExpression importSource = ((PyFromImportStatement)statement).getImportSource();
            if (importReferenceExpression != null && importSource != null && !this.isImportFromTheSamePackage(importSource)) {
                this.checkReference(importReferenceExpression, importSource);
            }
        }

        private boolean isImportFromTheSamePackage(@NotNull PyReferenceExpression importSource) {
            PsiDirectory currentFileDirectory;
            if (importSource == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((currentFileDirectory = importSource.getContainingFile().getContainingDirectory()) != null && PyUtil.isPackage(currentFileDirectory, true, (PsiElement)importSource)) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(this.myTypeEvalContext);
                return StreamEx.of((Object[])importSource.getReference(resolveContext).multiResolve(false)).map(ResolveResult::getElement).select(PyFile.class).map(PsiFile::getContainingDirectory).nonNull().map(PsiDirectory::getVirtualFile).anyMatch(importedSourceDir -> VfsUtilCore.isAncestor((VirtualFile)importedSourceDir, (VirtualFile)currentFileDirectory.getVirtualFile(), (boolean)false));
            }
            return false;
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyExpression qualifier = node.getQualifier();
            if (PyProtectedMemberInspection.this.ignoreAnnotations && PsiTreeUtil.getParentOfType((PsiElement)node, PyAnnotation.class) != null) {
                return;
            }
            if (qualifier == null || ArrayUtil.contains((String)qualifier.getText(), (String[])new String[]{"self", "cls"})) {
                return;
            }
            if (this.isImportFromTheSamePackage(node)) {
                return;
            }
            this.checkReference(node, qualifier);
        }

        private void checkReference(@NotNull PyReferenceExpression node, @NotNull PyExpression qualifier) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (qualifier == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            String name = node.getName();
            ArrayList<Object> quickFixes = new ArrayList<Object>();
            quickFixes.add((Object)new PyRenameElementQuickFix((PsiElement)node));
            if (name != null && name.startsWith("_") && !name.startsWith("__") && !name.endsWith("__")) {
                PyType type;
                PyClass parentClass;
                PsiPolyVariantReference reference = node.getReference(this.getResolveContext());
                for (PyInspectionExtension inspectionExtension : (PyInspectionExtension[])PyInspectionExtension.EP_NAME.getExtensions()) {
                    if (!inspectionExtension.ignoreProtectedSymbol(node, this.myTypeEvalContext)) continue;
                    return;
                }
                PsiElement resolvedExpression = reference.resolve();
                PyClass resolvedClass = this.getNotPyiClassOwner(resolvedExpression);
                if (resolvedExpression instanceof PyTargetExpression) {
                    String newName = StringUtil.trimLeading((String)name, (char)'_');
                    if (resolvedClass != null) {
                        Set<String> usedNames;
                        String qFixName = resolvedClass.getProperties().containsKey(newName) ? PyBundle.message("QFIX.use.property", new Object[0]) : PyBundle.message("QFIX.add.property", new Object[0]);
                        quickFixes.add(new PyAddPropertyForFieldQuickFix(qFixName));
                        PyClassType classType = PyUtil.as(this.myTypeEvalContext.getType(resolvedClass), PyClassType.class);
                        if (classType != null && !(usedNames = classType.getMemberNames(true, this.myTypeEvalContext)).contains(newName)) {
                            quickFixes.add(new PyMakePublicQuickFix());
                        }
                    }
                }
                if (PyProtectedMemberInspection.this.ignoreTestFunctions) {
                    for (PsiElement item = node.getParent(); item != null && !(item instanceof PsiFileSystemItem); item = item.getParent()) {
                        if (!PyTestsSharedKt.isTestElement(item, ThreeState.UNSURE, this.myTypeEvalContext)) continue;
                        return;
                    }
                }
                if ((parentClass = this.getClassOwner((PsiElement)node)) != null) {
                    if (parentClass.isSubclass(resolvedClass, this.myTypeEvalContext)) {
                        return;
                    }
                    PyClass outerClass = this.getClassOwner((PsiElement)parentClass);
                    while (outerClass != null) {
                        if (outerClass.isSubclass(resolvedClass, this.myTypeEvalContext)) {
                            return;
                        }
                        outerClass = this.getClassOwner((PsiElement)outerClass);
                    }
                }
                String bundleKey = (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyModuleType ? "INSP.protected.member.$0.access.module" : "INSP.protected.member.$0.access";
                this.registerProblem((PsiElement)node, PyBundle.message(bundleKey, name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
        }

        @Nullable
        private PyClass getNotPyiClassOwner(@Nullable PsiElement element) {
            PyClass owner = this.getClassOwner(element);
            return owner == null ? null : PyiUtil.getOriginalElementOrLeaveAsIs(owner, PyClass.class);
        }

        @Nullable
        private PyClass getClassOwner(@Nullable PsiElement element) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            while (owner != null) {
                if (owner instanceof PyClass) {
                    return (PyClass)owner;
                }
                owner = ScopeUtil.getScopeOwner((PsiElement)owner);
            }
            return null;
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression source = node.getImportSource();
            if (source == null) {
                return;
            }
            Set<String> dunderAlls = this.collectDunderAlls(source);
            if (dunderAlls == null) {
                return;
            }
            ((StreamEx)StreamEx.of((Object[])node.getImportElements()).map(PyImportElement::getImportReferenceExpression).nonNull().filter(referenceExpression -> !dunderAlls.contains(referenceExpression.getName()) && !this.resolvesToFileSystemItem((PyReferenceExpression)referenceExpression))).forEach(referenceExpression -> {
                String message = "'" + referenceExpression.getName() + "' is not declared in __all__";
                this.registerProblem((PsiElement)referenceExpression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            });
        }

        @Nullable
        private Set<String> collectDunderAlls(@NotNull PyReferenceExpression source) {
            PyResolveContext resolveContext;
            List resolvedDunderAlls;
            if (source == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if ((resolvedDunderAlls = StreamEx.of((Object[])source.getReference(resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(this.myTypeEvalContext)).multiResolve(false)).map(ResolveResult::getElement).select(PyFile.class).map(PyFile::getDunderAll).toList()).isEmpty()) {
                return null;
            }
            HashSet<String> result = new HashSet<String>();
            for (List dunderAll : resolvedDunderAlls) {
                if (dunderAll == null) {
                    return null;
                }
                result.addAll(dunderAll);
            }
            return result;
        }

        private boolean resolvesToFileSystemItem(@NotNull PyReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(this.myTypeEvalContext);
            return ContainerUtil.exists((Object[])referenceExpression.getReference(resolveContext).multiResolve(false), result -> result.getElement() instanceof PsiFileSystemItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyProtectedMemberInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isImportFromTheSamePackage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectDunderAlls";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolvesToFileSystemItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

