/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypeCheckerInspectionProblemRegistrar;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionReturnTypeQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeCheckerInspection
extends PyInspection {
    private static final Logger LOG = Logger.getInstance((String)PyTypeCheckerInspection.class.getName());
    private static final Key<Long> TIME_KEY = Key.create((String)"PyTypeCheckerInspection.StartTime");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            session.putUserData(TIME_KEY, (Object)System.nanoTime());
        }
        return new Visitor(holder, session);
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Long startTime;
        if (session == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(3);
        }
        if (LOG.isDebugEnabled() && (startTime = (Long)session.getUserData(TIME_KEY)) != null) {
            LOG.debug(String.format("[%d] elapsed time: %d ms\n", Thread.currentThread().getId(), (System.nanoTime() - startTime) / 1000000L));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectionFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AnalyzeArgumentResult {
        @NotNull
        private final PyExpression myArgument;
        @Nullable
        private final PyType myExpectedType;
        @Nullable
        private final PyType myExpectedTypeAfterSubstitution;
        @Nullable
        private final PyType myActualType;
        private final boolean myIsMatched;

        AnalyzeArgumentResult(@NotNull PyExpression argument, @Nullable PyType expectedType, @Nullable PyType expectedTypeAfterSubstitution, @Nullable PyType actualType, boolean isMatched) {
            if (argument == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(0);
            }
            this.myArgument = argument;
            this.myExpectedType = expectedType;
            this.myExpectedTypeAfterSubstitution = expectedTypeAfterSubstitution;
            this.myActualType = actualType;
            this.myIsMatched = isMatched;
        }

        @NotNull
        public PyExpression getArgument() {
            PyExpression pyExpression = this.myArgument;
            if (pyExpression == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(1);
            }
            return pyExpression;
        }

        @Nullable
        public PyType getExpectedType() {
            return this.myExpectedType;
        }

        @Nullable
        public PyType getExpectedTypeAfterSubstitution() {
            return this.myExpectedTypeAfterSubstitution;
        }

        @Nullable
        public PyType getActualType() {
            return this.myActualType;
        }

        public boolean isMatched() {
            return this.myIsMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AnalyzeCalleeResults {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyCallable myCallable;
        @NotNull
        private final List<AnalyzeArgumentResult> myResults;

        AnalyzeCalleeResults(@NotNull PyCallableType callableType, @Nullable PyCallable callable, @NotNull List<AnalyzeArgumentResult> results) {
            if (callableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(0);
            }
            if (results == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(1);
            }
            this.myCallableType = callableType;
            this.myCallable = callable;
            this.myResults = results;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(2);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getCallable() {
            return this.myCallable;
        }

        @NotNull
        public List<AnalyzeArgumentResult> getResults() {
            List<AnalyzeArgumentResult> list = this.myResults;
            if (list == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPySubscriptionExpression(PySubscriptionExpression node) {
            if (this.myTypeEvalContext.getType(node.getOperand()) instanceof PyTypedDictType) {
                return;
            }
            this.checkCallSite(node);
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.checkIteratedValue(node.getForPart().getSource(), node.isAsync());
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (owner instanceof PyFunction) {
                PyFunction function = (PyFunction)owner;
                PyAnnotation annotation = function.getAnnotation();
                String typeCommentAnnotation = function.getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyExpression returnExpr = node.getExpression();
                    PyNoneType actual = returnExpr != null ? this.myTypeEvalContext.getType(returnExpr) : PyNoneType.INSTANCE;
                    PyType expected = this.getExpectedReturnType(function);
                    if (!PyTypeChecker.match(expected, (PyType)actual, this.myTypeEvalContext)) {
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        String actualName = PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix localQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, actualName, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix globalQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, null, this.myTypeEvalContext);
                        this.registerProblem((PsiElement)(returnExpr != null ? returnExpr : node), String.format("Expected type '%s', got '%s' instead", expectedName, actualName), localQuickFix, globalQuickFix);
                    }
                }
            }
        }

        @Nullable
        private PyType getExpectedReturnType(@NotNull PyFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyType returnType = this.myTypeEvalContext.getReturnType(function);
            if (function.isAsync() || function.isGenerator()) {
                return (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(returnType));
            }
            return returnType;
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            PyType actual;
            ScopeOwner owner = ScopeUtil.getScopeOwner(node);
            if (owner instanceof PyClass) {
                return;
            }
            PyExpression value = node.findAssignedValue();
            if (value == null) {
                return;
            }
            PyType expected = this.myTypeEvalContext.getType(node);
            if (!PyTypeChecker.match(expected, actual = this.tryPromotingType(value, expected), this.myTypeEvalContext)) {
                this.registerProblem((PsiElement)value, String.format("Expected type '%s', got '%s' instead", PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext), PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext)));
            }
        }

        @Nullable
        private PyType tryPromotingType(@NotNull PyExpression value, @Nullable PyType expected) {
            PyType promotedToLiteral;
            if (value == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(value, expected, this.myTypeEvalContext)) instanceof PyLiteralType) {
                return promotedToLiteral;
            }
            return PyTypedDictTypeProvider.Companion.promoteToTypedDict(value, expected, this.myTypeEvalContext);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyAnnotation annotation = node.getAnnotation();
            String typeCommentAnnotation = node.getTypeCommentAnnotation();
            if (annotation != null || typeCommentAnnotation != null) {
                if (!PyUtil.isEmptyFunction(node)) {
                    ReturnVisitor visitor2 = new ReturnVisitor(node);
                    node.getStatementList().accept(visitor2);
                    if (!visitor2.myHasReturns) {
                        PyType expected = this.getExpectedReturnType(node);
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        if (expected != null && !(expected instanceof PyNoneType)) {
                            this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), String.format("Expected to return '%s', got no return", expectedName));
                        }
                    }
                }
                if (PyUtil.isInitMethod(node) && !(this.getExpectedReturnType(node) instanceof PyNoneType)) {
                    this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), "__init__ should return None");
                }
            }
        }

        @Override
        public void visitPyComprehensionElement(PyComprehensionElement node) {
            super.visitPyComprehensionElement(node);
            for (PyComprehensionForComponent forComponent : node.getForComponents()) {
                this.checkIteratedValue(forComponent.getIteratedList(), forComponent.isAsync());
            }
        }

        private void checkCallSite(@NotNull PyCallSiteExpression callSite) {
            List calleesResults;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (!Visitor.matchedCalleeResultsExist(calleesResults = ((StreamEx)StreamEx.of(PyCallExpressionHelper.mapArguments(callSite, this.getResolveContext())).filter(mapping -> mapping.getUnmappedArguments().isEmpty() && mapping.getUnmappedParameters().isEmpty())).map(mapping -> this.analyzeCallee(callSite, (PyCallExpression.PyArgumentsMapping)mapping)).nonNull().toList())) {
                PyTypeCheckerInspectionProblemRegistrar.registerProblem(this, callSite, Visitor.getArgumentTypes(calleesResults), calleesResults, this.myTypeEvalContext);
            }
        }

        private void checkIteratedValue(@Nullable PyExpression iteratedValue, boolean isAsync) {
            if (iteratedValue != null) {
                String iterableClassName;
                PyType type = this.myTypeEvalContext.getType(iteratedValue);
                String string = iterableClassName = isAsync ? "AsyncIterable" : "Iterable";
                if (type != null && !PyTypeChecker.isUnknown(type, this.myTypeEvalContext) && !PyABCUtil.isSubtype(type, iterableClassName, this.myTypeEvalContext)) {
                    String typeName = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                    this.registerProblem((PsiElement)iteratedValue, String.format("Expected 'collections.%s', got '%s' instead", iterableClassName, typeName));
                }
            }
        }

        @Nullable
        private AnalyzeCalleeResults analyzeCallee(@NotNull PyCallSiteExpression callSite, @NotNull PyCallExpression.PyArgumentsMapping mapping) {
            PyCallableParameter keywordContainer;
            PyCallableType callableType;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (mapping == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if ((callableType = mapping.getCallableType()) == null) {
                return null;
            }
            ArrayList<AnalyzeArgumentResult> result = new ArrayList<AnalyzeArgumentResult>();
            PyExpression receiver = callSite.getReceiver(callableType.getCallable());
            Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyReceiver(receiver, this.myTypeEvalContext);
            Map<PyExpression, PyCallableParameter> mappedParameters = mapping.getMappedParameters();
            for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(mappedParameters).entrySet()) {
                PyExpression argument = entry.getKey();
                PyCallableParameter parameter = entry.getValue();
                PyType expected = parameter.getArgumentType(this.myTypeEvalContext);
                PyType actual = PyLiteralType.Companion.promoteToLiteral(argument, expected, this.myTypeEvalContext);
                boolean matched = this.matchParameterAndArgument(expected, actual, argument, substitutions);
                result.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
            PyCallableParameter positionalContainer = PyCallExpressionHelper.getMappedPositionalContainer(mappedParameters);
            if (positionalContainer != null) {
                result.addAll(this.analyzeContainerMapping(positionalContainer, PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(mappedParameters), substitutions));
            }
            if ((keywordContainer = PyCallExpressionHelper.getMappedKeywordContainer(mappedParameters)) != null) {
                result.addAll(this.analyzeContainerMapping(keywordContainer, PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(mappedParameters), substitutions));
            }
            return new AnalyzeCalleeResults(callableType, callableType.getCallable(), result);
        }

        @NotNull
        private List<AnalyzeArgumentResult> analyzeContainerMapping(@NotNull PyCallableParameter container, @NotNull List<PyExpression> arguments, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (container == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            PyType expected = container.getArgumentType(this.myTypeEvalContext);
            PyType expectedWithSubstitutions = this.substituteGenerics(expected, substitutions);
            if (PyTypeChecker.hasGenerics(expected, this.myTypeEvalContext)) {
                PyType actual = PyUnionType.union(ContainerUtil.map(arguments, this.myTypeEvalContext::getType));
                boolean matched = this.matchParameterAndArgument(expected, actual, null, substitutions);
                List list = ContainerUtil.map(arguments, argument -> new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched));
                if (list == null) {
                    Visitor.$$$reportNull$$$0(9);
                }
                return list;
            }
            List list = ContainerUtil.map(arguments, argument -> {
                PyType actual = this.myTypeEvalContext.getType((PyTypedElement)argument);
                boolean matched = this.matchParameterAndArgument(expected, actual, (PyExpression)argument, substitutions);
                return new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched);
            });
            if (list == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            return list;
        }

        private boolean matchParameterAndArgument(@Nullable PyType parameterType, @Nullable PyType argumentType, @Nullable PyExpression argument, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            return parameterType instanceof PyTypedDictType && argument instanceof PyDictLiteralExpression ? PyTypedDictType.Companion.match((PyTypedDictType)parameterType, (PyDictLiteralExpression)argument, this.myTypeEvalContext) : PyTypeChecker.match(parameterType, argumentType, this.myTypeEvalContext, substitutions) && !PyProtocolsKt.matchingProtocolDefinitions(parameterType, argumentType, this.myTypeEvalContext);
        }

        @Nullable
        private PyType substituteGenerics(@Nullable PyType expectedArgumentType, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            return PyTypeChecker.hasGenerics(expectedArgumentType, this.myTypeEvalContext) ? PyTypeChecker.substitute(expectedArgumentType, substitutions, this.myTypeEvalContext) : null;
        }

        private static boolean matchedCalleeResultsExist(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            return calleesResults.stream().anyMatch(calleeResults -> calleeResults.getResults().stream().allMatch(AnalyzeArgumentResult::isMatched));
        }

        @NotNull
        private static List<PyType> getArgumentTypes(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            List list = ContainerUtil.map((Collection)calleesResults.stream().map(AnalyzeCalleeResults::getResults).max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList()), AnalyzeArgumentResult::getActualType);
            if (list == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSite";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 8: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleesResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "analyzeContainerMapping";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedReturnType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tryPromotingType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCallSite";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeCallee";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeContainerMapping";
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "matchParameterAndArgument";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteGenerics";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "matchedCalleeResultsExist";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgumentTypes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ReturnVisitor
        extends PyRecursiveElementVisitor {
            private final PyFunction myFunction;
            private boolean myHasReturns = false;

            ReturnVisitor(PyFunction function) {
                this.myFunction = function;
            }

            @Override
            public void visitPyReturnStatement(PyReturnStatement node) {
                if (ScopeUtil.getScopeOwner((PsiElement)node) == this.myFunction) {
                    this.myHasReturns = true;
                }
            }
        }
    }
}

