/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actions.ConvertIndentsActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import org.jetbrains.annotations.NotNull;

public class ConvertIndentsFix
implements LocalQuickFix {
    private final boolean myToSpaces;

    public ConvertIndentsFix(boolean toSpaces) {
        this.myToSpaces = toSpaces;
    }

    @NotNull
    public String getName() {
        String string = this.myToSpaces ? PyBundle.message("QFIX.convert.indents.to.spaces", new Object[0]) : PyBundle.message("QFIX.convert.indents.to.tabs", new Object[0]);
        if (string == null) {
            ConvertIndentsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.convert.indents", new Object[0]);
        if (string == null) {
            ConvertIndentsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            ConvertIndentsFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ConvertIndentsFix.$$$reportNull$$$0(3);
        }
        PsiFile file = descriptor2.getPsiElement().getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null) {
            int tabSize = CodeStyle.getIndentSize((PsiFile)file);
            TextRange allDoc = new TextRange(0, document.getTextLength());
            if (this.myToSpaces) {
                ConvertIndentsActionBase.convertIndentsToSpaces((Document)document, (int)tabSize, (TextRange)allDoc);
            } else {
                ConvertIndentsActionBase.convertIndentsToTabs((Document)document, (int)tabSize, (TextRange)allDoc);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

