/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinRegistryService;
import com.jetbrains.python.sdk.flavors.WindowsStoreServiceKt;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinPythonSdkFlavor
extends CPythonSdkFlavor {
    @NotNull
    private static final Key<String> APPX_PYTHON_CACHE = new Key("PythonFromStoreCache");
    private static final String NOTHING = "";
    private static final String[] REG_ROOTS = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
    private static final Map<String, String> REGISTRY_MAP = ImmutableMap.of((Object)"Python", (Object)"python.exe", (Object)"IronPython", (Object)"ipy.exe");
    @NotNull
    private final ClearableLazyValue<Set<String>> myRegistryCache = ClearableLazyValue.createAtomic(() -> WinPythonSdkFlavor.findInRegistry(this.getWinRegistryService()));

    public static WinPythonSdkFlavor getInstance() {
        return (WinPythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(WinPythonSdkFlavor.class);
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isWindows;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        VirtualFile pythonFromStore;
        VirtualFile installLocation;
        TreeSet<String> candidates = new TreeSet<String>();
        this.findInCandidatePaths(candidates, "python.exe", "jython.bat", "pypy.exe");
        WinPythonSdkFlavor.findInstallations(candidates, "python.exe", PythonHelpersLocator.getHelpersRoot().getParent());
        if (SystemInfo.isWin10OrNewer && (installLocation = WinPythonSdkFlavor.getInstallationLocationForStoreWithCache(context)) != null && (pythonFromStore = installLocation.findChild("python.exe")) != null) {
            candidates.add(pythonFromStore.getPath());
        }
        TreeSet<String> treeSet = candidates;
        if (treeSet == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static VirtualFile getInstallationLocationForStoreWithCache(@Nullable UserDataHolder context) {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (context != null) {
            Key<String> key = APPX_PYTHON_CACHE;
            synchronized (key) {
                String result = (String)context.getUserData(APPX_PYTHON_CACHE);
                if (result != null) {
                    return result.equals(NOTHING) ? null : fs.refreshAndFindFileByPath(result);
                }
                VirtualFile python = WinPythonSdkFlavor.getInstallationLocationForStore((VirtualFileSystem)fs);
                context.putUserData(APPX_PYTHON_CACHE, (Object)(python != null ? python.getPath() : NOTHING));
                return python;
            }
        }
        return WinPythonSdkFlavor.getInstallationLocationForStore((VirtualFileSystem)fs);
    }

    @Nullable
    private static VirtualFile getInstallationLocationForStore(@NotNull VirtualFileSystem fs) {
        if (fs == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return WindowsStoreServiceKt.findInstallLocationForPackage("Python", fs);
    }

    private void findInCandidatePaths(Set<String> candidates, String ... exe_names) {
        for (String name : exe_names) {
            WinPythonSdkFlavor.findInstallations(candidates, name, "C:\\", "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(candidates, name);
        }
        this.findInRegistry(candidates);
    }

    @Override
    public boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (super.isValidSdkHome(path)) {
            return true;
        }
        File file = new File(path);
        return WinPythonSdkFlavor.mayBeAppXReparsePoint(file) && this.isValidSdkPath(file);
    }

    @Override
    public void dropCaches() {
        this.myRegistryCache.drop();
    }

    private static boolean mayBeAppXReparsePoint(@NotNull File file) {
        if (file == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (!SystemInfo.isWin10OrNewer) {
            return false;
        }
        String localAppData = System.getenv("LOCALAPPDATA");
        if (localAppData == null) {
            return false;
        }
        File localAppDataFile = new File(localAppData);
        if (!FileUtil.isAncestor((File)localAppDataFile, (File)file, (boolean)true)) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        Object[] files = parent.listFiles();
        return files != null && ArrayUtil.contains((Object)file, (Object[])files);
    }

    void findInRegistry(@NotNull Collection<String> candidates) {
        if (candidates == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        candidates.addAll((Collection)this.myRegistryCache.getValue());
    }

    @NotNull
    protected WinRegistryService getWinRegistryService() {
        WinRegistryService winRegistryService = (WinRegistryService)ApplicationManager.getApplication().getService(WinRegistryService.class);
        if (winRegistryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        return winRegistryService;
    }

    private static void findInstallations(Set<String> candidates, String exe_name, String ... roots) {
        for (String root : roots) {
            WinPythonSdkFlavor.findSubdirInstallations(candidates, root, FileUtilRt.getNameWithoutExtension((String)exe_name), exe_name);
        }
    }

    public static void findInPath(Collection<? super String> candidates, String exeName) {
        String path = System.getenv("PATH");
        if (path == null) {
            return;
        }
        for (String pathEntry : StringUtil.split((String)path, (String)";")) {
            File f;
            if (pathEntry.startsWith("\"") && pathEntry.endsWith("\"")) {
                if (pathEntry.length() < 2) continue;
                pathEntry = pathEntry.substring(1, pathEntry.length() - 1);
            }
            if (!(f = new File(pathEntry, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)f.getPath()));
        }
    }

    @NotNull
    private static Set<String> findInRegistry(@NotNull WinRegistryService registryService) {
        if (registryService == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(6);
        }
        HashSet<String> result = new HashSet<String>();
        for (String regRoot : REG_ROOTS) {
            for (Map.Entry<String, String> entry : REGISTRY_MAP.entrySet()) {
                String productId = entry.getKey();
                String exePath = entry.getValue();
                String companiesPath = String.format("%s\\SOFTWARE\\%s", regRoot, productId);
                String companiesPathWow = String.format("%s\\SOFTWARE\\Wow6432Node\\%s", regRoot, productId);
                for (String path : new String[]{companiesPath, companiesPathWow}) {
                    List<String> companies = registryService.listBranches(path);
                    for (String company : companies) {
                        String pathToCompany = path + '\\' + company;
                        List<String> versions = registryService.listBranches(pathToCompany);
                        for (String version : versions) {
                            File interpreter;
                            String folder = registryService.getDefaultKey(pathToCompany + '\\' + version + "\\InstallPath");
                            if (folder == null || !(interpreter = new File(folder, exePath)).exists()) continue;
                            result.add(FileUtil.toSystemDependentName((String)interpreter.getPath()));
                        }
                    }
                }
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            WinPythonSdkFlavor.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static void findSubdirInstallations(Collection<String> candidates, String rootDir, String dir_prefix, String exe_name) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(rootDir);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile python_exe;
                if (!dir.isDirectory() || !StringUtil.toLowerCase((String)dir.getName()).startsWith(dir_prefix) || (python_exe = dir.findChild(exe_name)) == null) continue;
                candidates.add(FileUtil.toSystemDependentName((String)python_exe.getPath()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/WinPythonSdkFlavor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWinRegistryService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstallationLocationForStore";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayBeAppXReparsePoint";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInRegistry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

