/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.plist.Plist;

public class Bundle {
    private static final FileFilter SYNTAX_FILES_FILTER = new BundleFilesFilter("tmlanguage", "plist", "tmlanguage.json");
    private static final FileFilter PREFERENCE_FILES_FILTER = new BundleFilesFilter("tmpreferences", "plist");
    protected final String myName;
    protected final File bundleFile;
    protected final BundleType myType;

    public Bundle(@NotNull String name, @NotNull String bundle, @NotNull BundleType type) {
        if (name == null) {
            Bundle.$$$reportNull$$$0(0);
        }
        if (bundle == null) {
            Bundle.$$$reportNull$$$0(1);
        }
        if (type == null) {
            Bundle.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.bundleFile = new File(bundle);
        this.myType = type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Bundle.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<File> getGrammarFiles() {
        return this.getFilesInBundle(this.myType.getSyntaxesPath(), SYNTAX_FILES_FILTER);
    }

    @NotNull
    public Collection<File> getPreferenceFiles() {
        return this.getFilesInBundle(this.myType.getPreferencesPath(), PREFERENCE_FILES_FILTER);
    }

    @NotNull
    public Collection<File> getSnippetFiles() {
        return this.getFilesInBundle(this.myType.getSnippetsPath(), new BundleFilesFilter(this.myType.getSnippetFileExtensions()));
    }

    @NotNull
    public BundleType getType() {
        BundleType bundleType = this.myType;
        if (bundleType == null) {
            Bundle.$$$reportNull$$$0(4);
        }
        return bundleType;
    }

    @NotNull
    private Collection<File> getFilesInBundle(@NotNull String path, @Nullable FileFilter filter) {
        if (path == null) {
            Bundle.$$$reportNull$$$0(5);
        }
        File directory = new File(this.bundleFile, path);
        Object[] files = null;
        try {
            files = directory.listFiles(filter);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        HashSet hashSet = files != null && files.length > 0 ? ContainerUtil.newHashSet((Object[])files) : Collections.emptySet();
        if (hashSet == null) {
            Bundle.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        return FileUtil.filesEqual((File)this.bundleFile, (File)bundle.bundleFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.bundleFile);
    }

    public String toString() {
        return "Bundle{name='" + this.myName + '\'' + ", path='" + this.bundleFile + '\'' + ", type=" + (Object)((Object)this.myType) + '}';
    }

    public Collection<String> getExtensions(File file, Plist plist) {
        return plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
    }

    public List<Pair<String, Plist>> loadPreferenceFile(File file) throws IOException {
        return Collections.singletonList(PreferencesReadUtil.retrieveSettingsPlist(TextMateService.getInstance().getPlistReader().read(file)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/bundles/Bundle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/bundles/Bundle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesInBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInBundle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BundleFilesFilter
    implements FileFilter {
        private final Set<String> myExtensions;

        public BundleFilesFilter(String ... extensions) {
            this.myExtensions = ContainerUtil.newHashSet((Object[])extensions);
        }

        @Override
        public boolean accept(@NotNull File path) {
            if (path == null) {
                BundleFilesFilter.$$$reportNull$$$0(0);
            }
            return this.myExtensions.contains(StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)path.getName())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/textmate/bundles/Bundle$BundleFilesFilter", "accept"));
        }
    }
}

