/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.VSCBundle;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public class BundleFactory {
    private static final Logger LOG = Logger.getInstance(BundleFactory.class);
    private final PlistReader myPlistReader;

    public BundleFactory(PlistReader plistReader) {
        this.myPlistReader = plistReader;
    }

    @Nullable
    public Bundle fromDirectory(@Nullable File directory) {
        BundleType type = BundleType.fromDirectory(directory);
        switch (type) {
            case TEXTMATE: {
                return this.fromTextMateBundle(directory);
            }
            case SUBLIME: {
                return new Bundle(directory.getName(), directory.getPath(), type);
            }
            case VSCODE: {
                return new VSCBundle(directory.getName(), directory.getPath());
            }
        }
        return null;
    }

    private Bundle fromTextMateBundle(File directory) {
        File infoPlist = new File(directory, "info.plist");
        try {
            if (infoPlist.exists() && infoPlist.isFile()) {
                Plist plist = this.myPlistReader.read(infoPlist);
                String bundleName = plist.getPlistValue("name", directory.getName()).getString();
                return new Bundle(bundleName, directory.getPath(), BundleType.TEXTMATE);
            }
        }
        catch (IOException e) {
            LOG.debug("Can't read textmate bundle data", (Throwable)e);
        }
        return null;
    }
}

