/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShSupport;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import com.intellij.sh.formatter.ShShfmtFormatterUtil;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShExternalFormatter
implements ExternalFormatProcessor {
    private static final Logger LOG = Logger.getInstance(ShExternalFormatter.class);
    @NonNls
    private static final List<String> KNOWN_SHELLS = Arrays.asList("bash", "posix", "mksh");

    public boolean activeForFile(@NotNull PsiFile file) {
        if (file == null) {
            ShExternalFormatter.$$$reportNull$$$0(0);
        }
        return ShSupport.getInstance().isExternalFormatterEnabled() && file instanceof ShFile;
    }

    @Nullable
    public TextRange format(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks) {
        if (source == null) {
            ShExternalFormatter.$$$reportNull$$$0(1);
        }
        if (range == null) {
            ShExternalFormatter.$$$reportNull$$$0(2);
        }
        this.doFormat(source.getProject(), source.getVirtualFile());
        return range;
    }

    @Nullable
    public String indent(@NotNull PsiFile source, int lineStartOffset) {
        if (source == null) {
            ShExternalFormatter.$$$reportNull$$$0(3);
        }
        return null;
    }

    private void doFormat(final @NotNull Project project, final @Nullable VirtualFile file) {
        if (project == null) {
            ShExternalFormatter.$$$reportNull$$$0(4);
        }
        if (file == null || !file.exists()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof ShFile)) {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiFile);
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        String shFmtExecutable = ShSettings.getShfmtPath();
        if ("I do mind".equals(shFmtExecutable)) {
            return;
        }
        if (!ShShfmtFormatterUtil.isValidPath(shFmtExecutable)) {
            Notification notification = new Notification(ShBundle.message("sh.title.case", new Object[0]), "", ShBundle.message("sh.fmt.install.question", new Object[0]), NotificationType.INFORMATION);
            notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.fmt.install", new Object[0]), () -> {
                notification.expire();
                ShShfmtFormatterUtil.download(project, settings, () -> Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.title.case", new Object[0]), "", ShBundle.message("sh.fmt.success.install", new Object[0]), NotificationType.INFORMATION)), () -> Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.title.case", new Object[0]), "", ShBundle.message("sh.fmt.cannot.download", new Object[0]), NotificationType.ERROR)));
            }));
            notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.fmt.no.thanks", new Object[0]), () -> {
                notification.expire();
                ShSettings.setShfmtPath("I do mind");
            }));
            Notifications.Bus.notify((Notification)notification);
            return;
        }
        String filePath = file.getPath();
        String realPath = FileUtil.toSystemDependentName((String)filePath);
        if (!new File(realPath).exists()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return;
        }
        final long before = document.getModificationStamp();
        documentManager.saveDocument(document);
        SmartList params = new SmartList();
        params.add("-ln=" + ShShebangParserUtil.getInterpreter((ShFile)psiFile, KNOWN_SHELLS, "bash"));
        if (!settings.useTabCharacter(file.getFileType())) {
            int tabSize = settings.getIndentSize(file.getFileType());
            params.add("-i=" + tabSize);
        }
        if (shSettings.BINARY_OPS_START_LINE) {
            params.add("-bn");
        }
        if (shSettings.SWITCH_CASES_INDENTED) {
            params.add("-ci");
        }
        if (shSettings.REDIRECT_FOLLOWED_BY_SPACE) {
            params.add("-sr");
        }
        if (shSettings.KEEP_COLUMN_ALIGNMENT_PADDING) {
            params.add("-kp");
        }
        if (shSettings.MINIFY_PROGRAM) {
            params.add("-mn");
        }
        params.add(realPath);
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(shFmtExecutable).withParameters((List)params);
            OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    int exitCode;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((exitCode = event.getExitCode()) == 0) {
                        String text = this.getOutput().getStdout();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            long after = document.getModificationStamp();
                            if (after > before) {
                                return;
                            }
                            CommandProcessor.getInstance().executeCommand(project, () -> {
                                WriteAction.run(() -> {
                                    document.setText((CharSequence)text);
                                    FileDocumentManager.getInstance().saveDocument(document);
                                });
                                file.putUserData(UndoConstants.FORCE_RECORD_UNDO, null);
                            }, ShBundle.message("sh.fmt.reformat.code.with", ShExternalFormatter.this.getId()), null, document);
                        });
                    } else {
                        ShExternalFormatter.showFailedNotification(this.getOutput().getStderr());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/formatter/ShExternalFormatter$1", "processTerminated"));
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> ((OSProcessHandler)handler).startNotify());
        }
        catch (ExecutionException e) {
            ShExternalFormatter.showFailedNotification(e.getMessage());
        }
    }

    private static void showFailedNotification(String stderr) {
        LOG.debug(stderr);
    }

    @NotNull
    public String getId() {
        return "shfmt";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/formatter/ShExternalFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "activeForFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doFormat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

