/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ignore.IgnoredFileGeneratorImpl;
import com.intellij.openapi.vcs.changes.ignore.psi.util.IgnoreFileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.ignore.GitIgnoreInStoreDirGenerator;
import git4idea.ignore.GitIgnoreInStoreDirGeneratorKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0006\u0010\u0019\u001a\u00020\fJ \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/ignore/GitIgnoreInStoreDirGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "needGenerate", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createGitignore", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "inDir", "doGenerate", "", "projectConfigDirPath", "", "projectConfigDirVFile", "generateGitignoreInStoreDirIfNeeded", "haveNotGitVcs", "", "inStoreDir", "ignore", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "isProjectSharedInGit", "markGenerated", "registerVfsListenerIfNeeded", "run", "skipGeneration", "VfsEventsListener", "intellij.vcs.git"})
public final class GitIgnoreInStoreDirGenerator {
    private final AtomicBoolean needGenerate;
    private final Project project;

    public final void run() {
        boolean $i$f$runReadAction = false;
        boolean listenerRegistered = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ GitIgnoreInStoreDirGenerator this$0;
            {
                this.this$0 = gitIgnoreInStoreDirGenerator;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(GitIgnoreInStoreDirGenerator.access$registerVfsListenerIfNeeded(this.this$0));
            }
        });
        if (!listenerRegistered) {
            this.generateGitignoreInStoreDirIfNeeded();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean registerVfsListenerIfNeeded() {
        String projectConfigDirPath = ProjectKt.getStateStore((Project)this.project).getProjectConfigDir();
        if (projectConfigDirPath == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir path not found. Project is default or not directory based.");
            this.needGenerate.set(false);
            return false;
        }
        VirtualFile projectConfigDirVFile = LocalFileSystem.getInstance().findFileByPath(projectConfigDirPath);
        if (projectConfigDirVFile != null && !IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile((Project)this.project, (VirtualFile)projectConfigDirVFile)) {
            this.needGenerate.set(false);
            return false;
        }
        if (projectConfigDirVFile != null) {
            VirtualFile virtualFile = this.project.getProjectFile();
            if (virtualFile != null) {
                if (virtualFile.exists()) return false;
            }
        }
        boolean bl = true;
        boolean needRegister = bl;
        if (!needRegister) return needRegister;
        GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().debug("Project file or project config directory doesn't exist. Register VFS listener and try generate .gitignore after files become available.");
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)new VfsEventsListener(this.project), (Disposable)this.project);
        return needRegister;
    }

    private final void generateGitignoreInStoreDirIfNeeded() {
        if (!this.needGenerate.compareAndSet(true, false)) {
            return;
        }
        String projectConfigDirPath = ProjectKt.getStateStore((Project)this.project).getProjectConfigDir();
        if (projectConfigDirPath == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir path not found. Project is default or not directory based.");
            return;
        }
        VirtualFile projectConfigDirVFile = LocalFileSystem.getInstance().findFileByPath(projectConfigDirPath);
        if (projectConfigDirVFile == null) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Project config dir not found in VFS by path " + projectConfigDirPath);
            return;
        }
        if (this.skipGeneration(this.project, projectConfigDirVFile, projectConfigDirPath)) {
            return;
        }
        this.doGenerate(this.project, projectConfigDirPath, projectConfigDirVFile);
    }

    private final boolean skipGeneration(Project project, VirtualFile projectConfigDirVFile, String projectConfigDirPath) {
        if (!IgnoredFileGeneratorImpl.needGenerateInternalIgnoreFile((Project)project, (VirtualFile)projectConfigDirVFile)) {
            this.needGenerate.set(false);
            return true;
        }
        if (VfsUtil.refreshAndFindChild((VirtualFile)projectConfigDirVFile, (String)".gitignore") != null) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        if (this.haveNotGitVcs(project, projectConfigDirPath)) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        if (this.isProjectSharedInGit(project)) {
            this.markGenerated(project, projectConfigDirVFile);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void doGenerate(Project project, String projectConfigDirPath, VirtualFile projectConfigDirVFile) {
        VcsKey gitVcsKey = GitVcs.getKey();
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider((Project)project, (VcsKey)gitVcsKey);
        if (ignoredFileContentProvider == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ignoredFileContentProvider, (String)"VcsImplUtil.findIgnoredF\u2026ect, gitVcsKey) ?: return");
        IgnoredFileContentProvider gitIgnoreContentProvider = ignoredFileContentProvider;
        Logger logger = GitIgnoreInStoreDirGeneratorKt.access$getLOG$p();
        StringBuilder stringBuilder = new StringBuilder().append("Generate .gitignore in ").append(projectConfigDirPath).append(" for ");
        VcsKey vcsKey = gitVcsKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsKey, (String)"gitVcsKey");
        logger.debug(stringBuilder.append(vcsKey.getName()).toString());
        VirtualFile gitIgnoreFile = this.createGitignore(projectConfigDirVFile);
        ExtensionPointName extensionPointName = IgnoredFileProvider.IGNORE_FILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"IgnoredFileProvider.IGNORE_FILE");
        for (IgnoredFileProvider ignoredFileProvider : (IgnoredFileProvider[])extensionPointName.getExtensions()) {
            String ignoredGroupDescription;
            IgnoredFileDescriptor[] ignoresInStoreDir;
            void $this$filterTo$iv$iv;
            Set set = ignoredFileProvider.getIgnoredFiles(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ignoredFileProvider.getIgnoredFiles(project)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IgnoredFileDescriptor ignore = (IgnoredFileDescriptor)element$iv$iv;
                boolean bl = false;
                IgnoredFileDescriptor ignoredFileDescriptor = ignore;
                Intrinsics.checkExpressionValueIsNotNull((Object)ignoredFileDescriptor, (String)"ignore");
                if (!this.inStoreDir(projectConfigDirPath, ignoredFileDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IgnoredFileDescriptor[] $this$toTypedArray$iv = (IgnoredFileDescriptor[])((List)destination$iv$iv);
            boolean $i$f$toTypedArray = false;
            IgnoredFileDescriptor[] thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new IgnoredFileDescriptor[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$toTypedArray$iv = ignoresInStoreDir;
            boolean bl = false;
            if ($this$toTypedArray$iv.length == 0) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitIgnoreContentProvider.buildIgnoreGroupDescription(ignoredFileProvider), (String)"gitIgnoreContentProvider\u2026tion(ignoredFileProvider)");
            IgnoreFileUtilKt.addNewElementsToIgnoreBlock((Project)project, (VirtualFile)gitIgnoreFile, (String)ignoredGroupDescription, (VcsKey)gitVcsKey, (IgnoredFileDescriptor[])Arrays.copyOf(ignoresInStoreDir, ignoresInStoreDir.length));
        }
        this.markGenerated(project, projectConfigDirVFile);
    }

    private final boolean haveNotGitVcs(Project project, String projectConfigDirPath) {
        FilePath filePath = VcsUtil.getFilePath((String)projectConfigDirPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"VcsUtil.getFilePath(projectConfigDirPath)");
        FilePath projectConfigDir = filePath;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)projectConfigDir);
        if (abstractVcs == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026onfigDir) ?: return false");
        AbstractVcs vcs = abstractVcs;
        return Intrinsics.areEqual((Object)vcs.getKeyInstanceMethod(), (Object)GitVcs.getKey()) ^ true;
    }

    private final boolean isProjectSharedInGit(Project project) {
        boolean bl;
        String string = project.getProjectFilePath();
        if (string == null) {
            return false;
        }
        String projectFilePathStr = string;
        FilePath filePath = VcsUtil.getFilePath((String)projectFilePathStr);
        Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"VcsUtil.getFilePath(projectFilePathStr)");
        FilePath projectFilePath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)projectFilePath);
        if (virtualFile == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VcsUtil.getVcsRootFor(pr\u2026FilePath) ?: return false");
        VirtualFile vcsRootForProjectFile = virtualFile;
        try {
            bl = Git.getInstance().untrackedFilePaths(project, vcsRootForProjectFile, CollectionsKt.listOf((Object)projectFilePath)).isEmpty();
        }
        catch (VcsException e) {
            GitIgnoreInStoreDirGeneratorKt.access$getLOG$p().warn("Cannot check " + projectFilePathStr + " for being unversioned", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final void markGenerated(Project project, VirtualFile projectConfigDirVFile) {
        IgnoredFileGeneratorImpl.markIgnoreFileRootAsGenerated((Project)project, (String)projectConfigDirVFile.getPath());
        this.needGenerate.set(false);
    }

    private final VirtualFile createGitignore(VirtualFile inDir) {
        Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<VirtualFile>(inDir){
            final /* synthetic */ VirtualFile $inDir;

            @NotNull
            public final VirtualFile invoke() {
                boolean $i$f$runWriteAction = false;
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ createGitignore.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)this.this$0.$inDir.createChildData((Object)this.this$0.$inDir, ".gitignore");
                    }
                });
            }
            {
                this.$inDir = virtualFile;
                super(0);
            }
        }), (int)1, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"invokeAndWaitIfNeeded { \u2026ata(inDir, GITIGNORE) } }");
        return (VirtualFile)object;
    }

    private final boolean inStoreDir(String projectConfigDirPath, IgnoredFileDescriptor ignore) {
        boolean bl;
        String string = ignore.getPath();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            bl = FileUtil.isAncestor((String)projectConfigDirPath, (String)it, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    public GitIgnoreInStoreDirGenerator(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.needGenerate = new AtomicBoolean(true);
    }

    public static final /* synthetic */ boolean access$registerVfsListenerIfNeeded(GitIgnoreInStoreDirGenerator $this) {
        return $this.registerVfsListenerIfNeeded();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/ignore/GitIgnoreInStoreDirGenerator$VfsEventsListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/ignore/GitIgnoreInStoreDirGenerator;Lcom/intellij/openapi/project/Project;)V", "filesChanged", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "projectFileAffected", "", "intellij.vcs.git"})
    private final class VfsEventsListener
    implements AsyncVfsEventsListener {
        private final Project project;

        public void filesChanged(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkParameterIsNotNull(events, (String)"events");
            if (!GitIgnoreInStoreDirGenerator.this.needGenerate.get() || this.project.isDisposed()) {
                return;
            }
            if (this.projectFileAffected(events)) {
                GitIgnoreInStoreDirGenerator.this.generateGitignoreInStoreDirIfNeeded();
            }
        }

        private final boolean projectFileAffected(List<? extends VFileEvent> events) {
            boolean bl;
            block1: {
                Sequence $this$any$iv = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)projectFileAffected.1.INSTANCE), (Function1)projectFileAffected.2.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)file, (Object)this.project.getProjectFile()) && file.exists())) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public VfsEventsListener(Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }
    }
}

