/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsBranchSettingsKt;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.config.GitVcsSettings;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesDashboardActions;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeStateHolder;
import git4idea.ui.branch.dashboard.FilteringBranchesTree$WhenMappings;
import git4idea.ui.branch.dashboard.FilteringTree;
import git4idea.ui.branch.dashboard.NodeDescriptorsModel;
import git4idea.ui.branch.dashboard.NodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0014J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u0014\u0010*\u001a\u0004\u0018\u00010&2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0014J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u0013H\u0014J\b\u00104\u001a\u000201H\u0002J\u0006\u00105\u001a\u000201J\b\u00106\u001a\u000201H\u0002J\b\u00107\u001a\u000201H\u0002J\u000e\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u0013J\b\u0010:\u001a\u000201H\u0002J\u0012\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030(*\u00020\u0003H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "Lgit4idea/ui/branch/dashboard/FilteringTree;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "rootNode", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lgit4idea/ui/branch/dashboard/BranchesDashboardController;Lgit4idea/ui/branch/dashboard/BranchTreeNode;)V", "getComponent", "()Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "expandedPaths", "Lcom/intellij/util/containers/SmartHashSet;", "Ljavax/swing/tree/TreePath;", "localBranchesNode", "localNodeExist", "", "nodeDescriptorFilter", "Lkotlin/Function1;", "nodeDescriptorsModel", "Lgit4idea/ui/branch/dashboard/NodeDescriptorsModel;", "remoteBranchesNode", "remoteNodeExist", "useDirectoryGrouping", "buildTreeNodesIfNeeded", "createNode", "nodeDescriptor", "getChildren", "", "getNodeClass", "Ljava/lang/Class;", "getRootNodeDescriptors", "", "getSelectedBranchNames", "", "", "getSelectedBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "getText", "installSearchField", "Lcom/intellij/ui/SearchTextField;", "textFieldBorder", "Ljavax/swing/border/Border;", "isEmptyModel", "onSpeedSearchUpdateComplete", "", "rebuildTree", "initial", "refreshNodeDescriptorsModel", "refreshTree", "restorePreviouslyExpandedPaths", "setupTreeExpansionListener", "toggleDirectoryGrouping", "state", "updateSpeedSearchBackground", "getDirectChildren", "intellij.vcs.git"})
public final class FilteringBranchesTree
extends FilteringTree<BranchTreeNode, BranchNodeDescriptor> {
    private final SmartHashSet<TreePath> expandedPaths;
    private final BranchTreeNode localBranchesNode;
    private final BranchTreeNode remoteBranchesNode;
    private final Function1<BranchNodeDescriptor, Boolean> nodeDescriptorFilter;
    private final NodeDescriptorsModel nodeDescriptorsModel;
    private boolean localNodeExist;
    private boolean remoteNodeExist;
    private boolean useDirectoryGrouping;
    @NotNull
    private final BranchesTreeComponent component;
    private final BranchesDashboardController uiController;

    public final void toggleDirectoryGrouping(boolean state) {
        this.useDirectoryGrouping = state;
        this.refreshTree();
    }

    @Override
    @NotNull
    public SearchTextField installSearchField(@Nullable Border textFieldBorder) {
        SearchTextField searchTextField = super.installSearchField(textFieldBorder);
        Intrinsics.checkExpressionValueIsNotNull((Object)searchTextField, (String)"super.installSearchField(textFieldBorder)");
        SearchTextField searchField = searchTextField;
        this.component.setSearchField(searchField);
        return searchField;
    }

    private final void setupTreeExpansionListener() {
        this.component.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).add((Object)event.getPath());
            }

            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).remove((Object)event.getPath());
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSelectedBranchNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSelectedBranches();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((BranchInfo)receiver).getBranchName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Set<BranchInfo> getSelectedBranches() {
        return this.component.getSelectedBranches();
    }

    private final void restorePreviouslyExpandedPaths() {
        TreeUtil.restoreExpandedPaths((JTree)((JTree)((Object)this.component)), (List)CollectionsKt.toList((Iterable)((Iterable)this.expandedPaths)));
    }

    @Override
    protected void onSpeedSearchUpdateComplete() {
        this.restorePreviouslyExpandedPaths();
        this.updateSpeedSearchBackground();
    }

    private final void updateSpeedSearchBackground() {
        FilteringTree.SearchTreeModel searchTreeModel = this.getSearchModel();
        Intrinsics.checkExpressionValueIsNotNull(searchTreeModel, (String)"searchModel");
        SpeedSearchSupply speedSearchSupply = searchTreeModel.getSpeedSearchSupply();
        if (!(speedSearchSupply instanceof SpeedSearch)) {
            speedSearchSupply = null;
        }
        SpeedSearch speedSearch = (SpeedSearch)speedSearchSupply;
        if (speedSearch == null) {
            return;
        }
        SpeedSearch speedSearch2 = speedSearch;
        SearchTextField searchTextField = this.component.getSearchField();
        if (searchTextField == null || (searchTextField = searchTextField.getTextEditor()) == null) {
            return;
        }
        SearchTextField textEditor = searchTextField;
        if (this.isEmptyModel()) {
            textEditor.setOpaque(true);
            speedSearch2.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    private final boolean isEmptyModel() {
        return this.getSearchModel().isLeaf(this.localBranchesNode) && this.getSearchModel().isLeaf(this.remoteBranchesNode);
    }

    @Override
    @NotNull
    protected Class<BranchTreeNode> getNodeClass() {
        return BranchTreeNode.class;
    }

    @Override
    @NotNull
    protected BranchTreeNode createNode(@NotNull BranchNodeDescriptor nodeDescriptor) {
        BranchTreeNode branchTreeNode;
        Intrinsics.checkParameterIsNotNull((Object)nodeDescriptor, (String)"nodeDescriptor");
        switch (FilteringBranchesTree$WhenMappings.$EnumSwitchMapping$0[nodeDescriptor.getType().ordinal()]) {
            case 1: {
                branchTreeNode = this.localBranchesNode;
                break;
            }
            case 2: {
                branchTreeNode = this.remoteBranchesNode;
                break;
            }
            default: {
                branchTreeNode = new BranchTreeNode(nodeDescriptor);
            }
        }
        return branchTreeNode;
    }

    @Override
    @NotNull
    protected Collection<BranchNodeDescriptor> getChildren(@NotNull BranchNodeDescriptor nodeDescriptor) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)nodeDescriptor, (String)"nodeDescriptor");
        switch (FilteringBranchesTree$WhenMappings.$EnumSwitchMapping$1[nodeDescriptor.getType().ordinal()]) {
            case 1: {
                collection = this.getRootNodeDescriptors();
                break;
            }
            case 2: {
                collection = this.getDirectChildren(this.localBranchesNode.getNodeDescriptor());
                break;
            }
            case 3: {
                collection = this.getDirectChildren(this.remoteBranchesNode.getNodeDescriptor());
                break;
            }
            case 4: {
                collection = this.getDirectChildren(nodeDescriptor);
                break;
            }
            default: {
                collection = CollectionsKt.emptyList();
            }
        }
        return collection;
    }

    private final Set<BranchNodeDescriptor> getDirectChildren(@NotNull BranchNodeDescriptor $this$getDirectChildren) {
        return this.nodeDescriptorsModel.getChildrenForParent($this$getDirectChildren);
    }

    @Override
    protected boolean rebuildTree(boolean initial) {
        boolean rebuilded = this.buildTreeNodesIfNeeded();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BranchesTreeStateHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        BranchesTreeStateHolder treeState = (BranchesTreeStateHolder)object;
        if (!initial) {
            treeState.createNewState();
        }
        this.getSearchModel().updateStructure();
        if (initial) {
            treeState.applyStateToTreeOrExpandAll();
        } else {
            BranchesTreeStateHolder.applyStateToTree$default(treeState, null, 1, null);
        }
        return rebuilded;
    }

    public final void refreshTree() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BranchesTreeStateHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        BranchesTreeStateHolder treeState = (BranchesTreeStateHolder)object;
        treeState.createNewState();
        this.refreshNodeDescriptorsModel();
        this.getSearchModel().updateStructure();
        BranchesTreeStateHolder.applyStateToTree$default(treeState, null, 1, null);
    }

    private final boolean buildTreeNodesIfNeeded() {
        BranchesDashboardController branchesDashboardController = this.uiController;
        boolean bl = false;
        boolean bl2 = false;
        BranchesDashboardController $this$with = branchesDashboardController;
        boolean bl3 = false;
        boolean changed = $this$with.checkForBranchesUpdate();
        if (!changed) {
            return false;
        }
        this.refreshNodeDescriptorsModel();
        return changed;
    }

    private final void refreshNodeDescriptorsModel() {
        boolean bl;
        BranchesDashboardController branchesDashboardController = this.uiController;
        boolean bl2 = false;
        boolean bl3 = false;
        BranchesDashboardController $this$with = branchesDashboardController;
        boolean bl4 = false;
        this.nodeDescriptorsModel.clear();
        Collection collection = $this$with.getLocalBranches();
        FilteringBranchesTree filteringBranchesTree = this;
        boolean bl5 = false;
        filteringBranchesTree.localNodeExist = bl = !collection.isEmpty();
        collection = $this$with.getRemoteBranches();
        filteringBranchesTree = this;
        bl5 = false;
        filteringBranchesTree.remoteNodeExist = bl = !collection.isEmpty();
        this.nodeDescriptorsModel.populateFrom((Sequence<BranchInfo>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)$this$with.getLocalBranches()), (Sequence)CollectionsKt.asSequence((Iterable)$this$with.getRemoteBranches())), this.useDirectoryGrouping);
    }

    @Override
    @Nullable
    protected String getText(@Nullable BranchNodeDescriptor nodeDescriptor) {
        Object object = nodeDescriptor;
        if (object == null || (object = ((BranchNodeDescriptor)object).getBranchInfo()) == null || (object = ((BranchInfo)object).getBranchName()) == null) {
            BranchNodeDescriptor branchNodeDescriptor = nodeDescriptor;
            object = branchNodeDescriptor != null ? branchNodeDescriptor.getDisplayName() : null;
        }
        return object;
    }

    private final List<BranchNodeDescriptor> getRootNodeDescriptors() {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        if (this.localNodeExist) {
            $this$apply.add(this.localBranchesNode.getNodeDescriptor());
        }
        if (this.remoteNodeExist) {
            $this$apply.add(this.remoteBranchesNode.getNodeDescriptor());
        }
        return list;
    }

    @NotNull
    public final BranchesTreeComponent getComponent() {
        return this.component;
    }

    public FilteringBranchesTree(@NotNull Project project, @NotNull BranchesTreeComponent component, @NotNull BranchesDashboardController uiController, @NotNull BranchTreeNode rootNode) {
        Application app$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)component), (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)uiController, (String)"uiController");
        Intrinsics.checkParameterIsNotNull((Object)rootNode, (String)"rootNode");
        super(project, (Tree)component, (DefaultMutableTreeNode)rootNode);
        this.component = component;
        this.uiController = uiController;
        this.expandedPaths = new SmartHashSet();
        this.localBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.LOCAL_ROOT, null, null, null, 14, null));
        this.remoteBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.REMOTE_ROOT, null, null, null, 14, null));
        this.nodeDescriptorFilter = (Function1)new Function1<BranchNodeDescriptor, Boolean>(this){
            final /* synthetic */ FilteringBranchesTree this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull BranchNodeDescriptor descriptor) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                if (descriptor.getType() == NodeType.GROUP_NODE) return true;
                if (!FilteringBranchesTree.access$getUiController$p(this.this$0).getShowOnlyMy()) return true;
                BranchInfo branchInfo = descriptor.getBranchInfo();
                if ((branchInfo != null ? branchInfo.isMy() : null) != ThreeState.YES) return false;
                return true;
            }
            {
                this.this$0 = filteringBranchesTree;
                super(1);
            }
        };
        this.nodeDescriptorsModel = new NodeDescriptorsModel(this.localBranchesNode.getNodeDescriptor(), this.remoteBranchesNode.getNodeDescriptor(), this.nodeDescriptorFilter);
        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
        DvcsBranchSettings dvcsBranchSettings = gitVcsSettings.getBranchSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)dvcsBranchSettings, (String)"GitVcsSettings.getInstance(project).branchSettings");
        this.useDirectoryGrouping = DvcsBranchSettingsKt.isGroupingEnabled((DvcsBranchSettings)dvcsBranchSettings, (GroupingKey)GroupingKey.GROUPING_BY_DIRECTORY);
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            PopupHandler.installPopupHandler((JComponent)((JComponent)((Object)this.getComponent())), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(project, this), (String)"BranchesTreePopup", (ActionManager)ActionManager.getInstance());
            this.setupTreeExpansionListener();
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BranchesTreeStateHolder.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            ((BranchesTreeStateHolder)object).setTree(this);
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
                final /* synthetic */ FilteringBranchesTree this$0;
                final /* synthetic */ Project $project$inlined;
                {
                    this.this$0 = filteringBranchesTree;
                    this.$project$inlined = project;
                }

                public final void run() {
                    boolean bl = false;
                    PopupHandler.installPopupHandler((JComponent)((JComponent)((Object)this.this$0.getComponent())), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(this.$project$inlined, this.this$0), (String)"BranchesTreePopup", (ActionManager)ActionManager.getInstance());
                    FilteringBranchesTree.access$setupTreeExpansionListener(this.this$0);
                    Project $this$service$iv = this.$project$inlined;
                    boolean $i$f$service = false;
                    Object object = $this$service$iv.getService(BranchesTreeStateHolder.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
                    ((BranchesTreeStateHolder)object).setTree(this.this$0);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    public /* synthetic */ FilteringBranchesTree(Project project, BranchesTreeComponent branchesTreeComponent, BranchesDashboardController branchesDashboardController, BranchTreeNode branchTreeNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            branchTreeNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.ROOT, null, null, null, 14, null));
        }
        this(project, branchesTreeComponent, branchesDashboardController, branchTreeNode);
    }

    public static final /* synthetic */ SmartHashSet access$getExpandedPaths$p(FilteringBranchesTree $this) {
        return $this.expandedPaths;
    }

    public static final /* synthetic */ BranchesDashboardController access$getUiController$p(FilteringBranchesTree $this) {
        return $this.uiController;
    }
}

