/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUtil {
    private Map<String, FileType> types;
    private final Map<FileType, Set<FileType>> mappings = new HashMap<FileType, Set<FileType>>();
    private final Set<FileType> noSeparators = new HashSet<FileType>();
    private static final Logger LOG = Logger.getInstance((String)FileTypeUtil.class.getName());

    public static synchronized FileTypeUtil getInstance() {
        return (FileTypeUtil)ServiceManager.getService(FileTypeUtil.class);
    }

    public FileTypeUtil() {
        this.createMappings();
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect().subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTypeUtil.this.types = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/maddyhome/idea/copyright/util/FileTypeUtil$1", "fileTypesChanged"));
            }
        });
        Objects.requireNonNull(CopyrightUpdaters.INSTANCE.getPoint()).addExtensionPointListener(() -> {
            this.types = null;
        }, false, (Disposable)application);
    }

    public static String buildComment(FileType type, String template, LanguageOptions options) {
        int i;
        String open;
        boolean allowLine;
        Commenter commenter = FileTypeUtil.getCommenter(type);
        if (commenter == null) {
            return "<No comments>";
        }
        String bs = commenter.getBlockCommentPrefix();
        String be = commenter.getBlockCommentSuffix();
        String ls = commenter.getLineCommentPrefix();
        if ((bs == null || be == null) && ls == null) {
            return "<No comments>";
        }
        boolean allowBlock = bs != null && be != null;
        boolean bl = allowLine = ls != null;
        if (allowLine && !allowBlock) {
            bs = ls;
            be = ls;
        }
        boolean allowSeparator = FileTypeUtil.getInstance().allowSeparators(type);
        String filler = options.getFiller();
        if (!allowSeparator && options.getFiller() == " ") {
            filler = "~";
        }
        boolean isBlock = options.isBlock();
        boolean isPrefix = options.isPrefixLines();
        if (isBlock && !allowBlock) {
            isPrefix = true;
        }
        boolean isBox = options.isBox() && options.isSeparateBefore() && options.isSeparateAfter() && options.getLenBefore() == options.getLenAfter();
        StringBuilder preview = new StringBuilder(80);
        String string = isBlock ? bs : (open = allowLine ? ls : bs);
        String close = isBlock ? be : (allowLine ? ls : be);
        StringBuilder pre = new StringBuilder(5);
        StringBuilder leader = new StringBuilder(5);
        StringBuilder post = new StringBuilder(5);
        if (filler == " ") {
            filler = open.substring(open.length() - 1);
        }
        int offset = 0;
        if (isBlock) {
            int pos = open.length() - 1;
            pre.append(allowBlock ? filler : Character.valueOf(open.charAt(pos)));
            while (pos > 0 && open.charAt(pos) == open.charAt(open.length() - 1)) {
                --pos;
                ++offset;
            }
            while (open.length() > 1 && pos >= 0) {
                leader.append(' ');
                --pos;
            }
            post.append(filler);
            if (!isPrefix) {
                pre = new StringBuilder(0);
            }
            if (!allowBlock) {
                close = filler;
            }
        } else {
            if (allowLine) {
                close = filler;
            }
            pre.append(open);
            post.append(close);
        }
        int diff = 0;
        if (options.isSeparateBefore()) {
            if (isBlock && isBox && allowBlock) {
                diff = close.length() - offset;
            }
            preview.append(open);
            for (i = open.length() + 1; i <= options.getLenBefore() - diff - post.length(); ++i) {
                preview.append(filler);
            }
            preview.append((CharSequence)post);
            preview.append('\n');
        } else if (isBlock) {
            preview.append(open).append('\n');
        }
        if (!template.isEmpty()) {
            String[] lines;
            for (String line : lines = template.split("\n", -1)) {
                if (options.isTrim()) {
                    line = line.trim();
                }
                line = StringUtil.trimStart((String)StringUtil.trimStart((String)line, (String)pre.toString()), (String)open);
                line = StringUtil.trimEnd((String)line, (String)close);
                preview.append((CharSequence)leader).append((CharSequence)pre);
                int len = 0;
                if (pre.length() > 0 && !line.isEmpty()) {
                    preview.append(' ');
                    ++len;
                }
                preview.append(line);
                if (isBox && (len += line.length() + leader.length() + pre.length()) < options.getLenBefore() - diff) {
                    while (len < options.getLenBefore() - diff - post.length()) {
                        preview.append(' ');
                        ++len;
                    }
                    if (isBlock || allowLine) {
                        preview.append(post.substring(0, options.getLenBefore() - diff - len));
                    }
                }
                if (!isBlock && !allowLine) {
                    if (preview.charAt(preview.length() - 1) != ' ') {
                        preview.append(' ');
                    }
                    preview.append(close);
                }
                preview.append('\n');
            }
        }
        preview.append((CharSequence)leader);
        if (options.isSeparateAfter()) {
            preview.append((CharSequence)pre);
            for (i = leader.length() + pre.length(); i < options.getLenAfter() - close.length(); ++i) {
                preview.append(filler);
            }
            preview.append(close);
            preview.append('\n');
        } else if (isBlock) {
            if (!allowBlock) {
                preview.append((CharSequence)pre).append('\n');
            } else {
                preview.append(close).append('\n');
            }
        }
        return preview.substring(0, preview.length() - 1);
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileTypeUtil.$$$reportNull$$$0(0);
        }
        if (file.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            return false;
        }
        return FileTypeUtil.isSupportedType(file.getFileType());
    }

    public static boolean isSupportedFile(PsiFile file) {
        if (file == null || file instanceof PsiDirectory || file instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        return FileTypeUtil.isSupportedType(virtualFile.getFileType());
    }

    public FileType[] getSupportedTypes() {
        HashSet<FileType> set = new HashSet<FileType>(this.getMap().values());
        return set.toArray(FileType.EMPTY_ARRAY);
    }

    public FileType getFileTypeByFile(VirtualFile file) {
        FileType type = file.getFileType();
        return this.getFileTypeByType(type);
    }

    public FileType getFileTypeByType(FileType type) {
        return this.getMap().get(type.getName());
    }

    public String getFileTypeNameByName(String name) {
        FileType type = this.getMap().get(name);
        return type != null ? type.getName() : name;
    }

    public static boolean hasBlockComment(FileType fileType) {
        Commenter commenter = FileTypeUtil.getCommenter(fileType);
        return commenter != null && commenter.getBlockCommentPrefix() != null;
    }

    public boolean allowSeparators(FileType fileType) {
        FileType type = this.getFileTypeByType(fileType);
        return !this.noSeparators.contains(type);
    }

    private static Commenter getCommenter(FileType fileType) {
        if (fileType instanceof LanguageFileType) {
            return (Commenter)LanguageCommenters.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage());
        }
        return null;
    }

    private void createMappings() {
        HashSet<LanguageFileType> maps = new HashSet<LanguageFileType>();
        maps.add(StdFileTypes.DTD);
        maps.add(StdFileTypes.XML);
        this.mappings.put((FileType)StdFileTypes.XML, maps);
        maps = new HashSet();
        maps.add(StdFileTypes.HTML);
        maps.add(StdFileTypes.XHTML);
        this.mappings.put((FileType)StdFileTypes.HTML, maps);
        maps = new HashSet();
        maps.add(StdFileTypes.JSP);
        this.mappings.put((FileType)StdFileTypes.JSP, maps);
        this.noSeparators.add((FileType)StdFileTypes.XML);
        this.noSeparators.add((FileType)StdFileTypes.HTML);
        this.noSeparators.add((FileType)StdFileTypes.JSP);
        this.noSeparators.add((FileType)StdFileTypes.JSPX);
    }

    private static boolean isSupportedType(FileType type) {
        if (type.isBinary() || type.getName().contains("IDEA") || "GUI_DESIGNER_FORM".equals(type.getName())) {
            return false;
        }
        if (type.equals(StdFileTypes.DTD)) {
            return true;
        }
        if (type.equals(StdFileTypes.HTML)) {
            return true;
        }
        if (type.equals(StdFileTypes.XHTML)) {
            return true;
        }
        if (type.getName().equals("Properties")) {
            return true;
        }
        if (CopyrightUpdaters.INSTANCE.forFileType(type) == null) {
            return false;
        }
        Commenter commenter = FileTypeUtil.getCommenter(type);
        return commenter != null && (commenter.getLineCommentPrefix() != null || commenter.getBlockCommentPrefix() != null);
    }

    private void loadFileTypes() {
        LOG.debug("loadFileTypes");
        HashMap<String, FileType> map = new HashMap<String, FileType>();
        for (FileType ftype : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (FileTypeUtil.isSupportedType(ftype)) {
                LOG.debug("adding " + ftype.getName());
                Iterator<FileType> iter = this.mappings.keySet().iterator();
                FileType type = ftype;
                while (iter.hasNext()) {
                    FileType fileType = iter.next();
                    Set<FileType> maps = this.mappings.get(fileType);
                    if (!maps.contains(ftype)) continue;
                    type = fileType;
                    break;
                }
                map.put(ftype.getName(), type);
                continue;
            }
            LOG.debug("ignoring " + ftype.getName());
        }
        this.types = map;
    }

    public FileType getFileTypeByName(String name) {
        return this.getMap().get(name);
    }

    @NotNull
    private Map<String, FileType> getMap() {
        if (this.types == null) {
            this.loadFileTypes();
        }
        Map<String, FileType> map = this.types;
        if (map == null) {
            FileTypeUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/maddyhome/idea/copyright/util/FileTypeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/maddyhome/idea/copyright/util/FileTypeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SortByName
    implements Comparator<FileType> {
        @Override
        public int compare(FileType a, FileType b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }
}

