/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

class CodeStyleCachedValueProvider
implements CachedValueProvider<CodeStyleSettings> {
    private static final Logger LOG = Logger.getInstance(CodeStyleCachedValueProvider.class);
    private static final Key<CodeStyleCachedValueProvider> PROVIDER_KEY = Key.create((String)"code.style.cached.value.provider");
    private static final int MAX_COMPUTATION_THREADS = 10;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final AsyncComputation myComputation;
    @NotNull
    private final Lock myComputationLock;
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CodeStyleCachedValueProvider", (int)10);

    CodeStyleCachedValueProvider(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(0);
        }
        this.myComputationLock = new ReentrantLock();
        this.myFile = file;
        this.myComputation = new AsyncComputation();
    }

    CodeStyleSettings tryGetSettings() {
        if (this.myComputationLock.tryLock()) {
            try {
                CodeStyleSettings codeStyleSettings = CachedValuesManager.getCachedValue(this.myFile, this);
                return codeStyleSettings;
            }
            finally {
                this.myComputationLock.unlock();
            }
        }
        return CodeStyleSettingsManager.getInstance(this.myFile.getProject()).getCurrentSettings();
    }

    @Override
    @NotNull
    public CachedValueProvider.Result<CodeStyleSettings> compute() {
        CodeStyleSettings settings = this.myComputation.getCurrResult();
        CodeStyleCachedValueProvider.logCached(this.myFile, settings);
        return new CachedValueProvider.Result<CodeStyleSettings>(settings, this.getDependencies(settings, this.myComputation));
    }

    Object @NotNull [] getDependencies(@NotNull CodeStyleSettings settings, @NotNull AsyncComputation computation) {
        if (settings == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(1);
        }
        if (computation == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(2);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        if (settings instanceof TransientCodeStyleSettings) {
            dependencies.addAll(((TransientCodeStyleSettings)settings).getDependencies());
        } else {
            dependencies.add(settings.getModificationTracker());
        }
        dependencies.add(computation.getTracker());
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    static synchronized CodeStyleCachedValueProvider getInstance(@NotNull PsiFile file) {
        CodeStyleCachedValueProvider instance;
        if (file == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(4);
        }
        if ((instance = (CodeStyleCachedValueProvider)file.getUserData(PROVIDER_KEY)) == null) {
            instance = new CodeStyleCachedValueProvider(file);
            file.putUserData(PROVIDER_KEY, instance);
        }
        return instance;
    }

    private static void logCached(@NotNull PsiFile file, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(6);
        }
        LOG.debug(String.format("File: %s (%s), cached: %s, tracker: %d", file.getName(), Integer.toHexString(file.hashCode()), settings, settings.getModificationTracker().getModificationCount()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleCachedValueProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleCachedValueProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logCached";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AsyncComputation {
        private final AtomicBoolean myIsActive = new AtomicBoolean();
        @NotNull
        private volatile CodeStyleSettings myCurrResult;
        @NotNull
        private final CodeStyleSettingsManager mySettingsManager;
        private final SimpleModificationTracker myTracker = new SimpleModificationTracker();
        private final Project myProject;

        private AsyncComputation() {
            this.myProject = CodeStyleCachedValueProvider.this.myFile.getProject();
            this.mySettingsManager = CodeStyleSettingsManager.getInstance(this.myProject);
            this.myCurrResult = this.mySettingsManager.getCurrentSettings();
        }

        private void start() {
            if (this.isRunOnBackground()) {
                ReadAction.nonBlocking(() -> this.computeSettings()).expireWith((Disposable)this.myProject).finishOnUiThread(ModalityState.NON_MODAL, val -> this.notifyCachedValueComputed()).submit(ourExecutorService);
            } else {
                ReadAction.run(() -> this.computeSettings());
                this.notifyOnEdt();
            }
        }

        private boolean isRunOnBackground() {
            Application application = ApplicationManager.getApplication();
            return !application.isUnitTestMode() && !application.isHeadlessEnvironment() && application.isDispatchThread();
        }

        private void notifyOnEdt() {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                this.notifyCachedValueComputed();
            } else {
                application.invokeLater(() -> this.notifyCachedValueComputed(), ModalityState.any());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeSettings() {
            try {
                CodeStyleSettings currSettings;
                CodeStyleCachedValueProvider.this.myComputationLock.lock();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computation started for " + CodeStyleCachedValueProvider.this.myFile.getName());
                }
                if ((currSettings = this.mySettingsManager.getCurrentSettings()) != this.mySettingsManager.getTemporarySettings()) {
                    TransientCodeStyleSettings modifiableSettings = new TransientCodeStyleSettings(CodeStyleCachedValueProvider.this.myFile, currSettings);
                    modifiableSettings.applyIndentOptionsFromProviders();
                    for (CodeStyleSettingsModifier modifier : CodeStyleSettingsModifier.EP_NAME.getExtensionList()) {
                        if (!modifier.modifySettings(modifiableSettings, CodeStyleCachedValueProvider.this.myFile)) continue;
                        LOG.debug("Modifier: " + modifier.getClass().getName());
                        modifiableSettings.setModifier(modifier);
                        currSettings = modifiableSettings;
                        break;
                    }
                }
                this.myCurrResult = currSettings;
                this.myTracker.incModificationCount();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computation ended for " + CodeStyleCachedValueProvider.this.myFile.getName());
                }
            }
            finally {
                CodeStyleCachedValueProvider.this.myComputationLock.unlock();
            }
        }

        @NotNull
        public CodeStyleSettings getCurrResult() {
            if (this.myIsActive.compareAndSet(false, true)) {
                this.start();
            }
            CodeStyleSettings codeStyleSettings = this.myCurrResult;
            if (codeStyleSettings == null) {
                AsyncComputation.$$$reportNull$$$0(0);
            }
            return codeStyleSettings;
        }

        private SimpleModificationTracker getTracker() {
            return this.myTracker;
        }

        void reset() {
            this.myIsActive.set(false);
        }

        private void notifyCachedValueComputed() {
            if (!this.myProject.isDisposed()) {
                CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(this.myProject);
                settingsManager.fireCodeStyleSettingsChanged(CodeStyleCachedValueProvider.this.myFile);
            }
            CodeStyleCachedValueProvider.this.myComputation.reset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleCachedValueProvider$AsyncComputation", "getCurrResult"));
        }
    }
}

