/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathReferenceManager {
    public static final ExtensionPointName<PathReferenceProvider> PATH_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.pathReferenceProvider");
    public static final ExtensionPointName<PathReferenceProvider> ANCHOR_REFERENCE_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.anchorReferenceProvider");

    @NotNull
    public static PathReferenceManager getInstance() {
        PathReferenceManager pathReferenceManager = ServiceManager.getService(PathReferenceManager.class);
        if (pathReferenceManager == null) {
            PathReferenceManager.$$$reportNull$$$0(0);
        }
        return pathReferenceManager;
    }

    public abstract PsiReference @NotNull [] createReferences(@NotNull PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    public abstract PsiReference @NotNull [] createReferences(@NotNull PsiElement var1, boolean var2, boolean var3, boolean var4, PathReferenceProvider ... var5);

    public abstract PsiReference[] createReferences(@NotNull PsiElement var1, boolean var2, boolean var3, boolean var4, FileType[] var5, PathReferenceProvider ... var6);

    public abstract PsiReference @NotNull [] createCustomReferences(@NotNull PsiElement var1, boolean var2, PathReferenceProvider ... var3);

    @Nullable
    public abstract PathReference getPathReference(@NotNull String var1, @NotNull PsiElement var2, PathReferenceProvider ... var3);

    @Nullable
    public abstract PathReference getCustomPathReference(@NotNull String var1, @NotNull Module var2, @NotNull PsiElement var3, PathReferenceProvider ... var4);

    @NotNull
    public abstract PathReferenceProvider getGlobalWebPathReferenceProvider();

    @NotNull
    public abstract PathReferenceProvider createStaticPathReferenceProvider(boolean var1);

    public static PsiReference[] getReferencesFromProvider(@NotNull PathReferenceProvider provider, @NotNull PsiElement psiElement, boolean soft) {
        if (provider == null) {
            PathReferenceManager.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            PathReferenceManager.$$$reportNull$$$0(2);
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        provider.createReferences(psiElement, references, soft);
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PathReferenceManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PathReferenceManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesFromProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

