/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.StubbedOccurrence;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.XIncludeStub;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.HashMap;

class DomStubBuilderVisitor {
    private final DomManagerImpl myManager;

    DomStubBuilderVisitor(DomManagerImpl manager) {
        this.myManager = manager;
    }

    void visitXmlElement(XmlElement element, ElementStub parent, int index) {
        String nsKey;
        if (XmlIncludeHandler.isXInclude((PsiElement)element)) {
            XmlTag tag = (XmlTag)element;
            new XIncludeStub(parent, tag.getAttributeValue("href"), tag.getAttributeValue("xpointer"));
            return;
        }
        DomInvocationHandler handler = this.myManager.getDomHandler(element);
        if (handler == null || handler.getAnnotation(Stubbed.class) == null && !handler.getChildDescription().isStubbed()) {
            return;
        }
        AbstractDomChildDescriptionImpl description = handler.getChildDescription();
        String string = nsKey = description instanceof DomChildrenDescription ? ((DomChildrenDescription)description).getXmlName().getNamespaceKey() : "";
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String elementClass = null;
            if (handler.getAnnotation(StubbedOccurrence.class) != null) {
                elementClass = ((Class)description.getType()).getName();
            }
            ElementStub stub = new ElementStub(parent, tag.getName(), StringUtil.notNullize((String)nsKey), index, description instanceof CustomDomChildrenDescription, elementClass, tag.getSubTags().length == 0 ? tag.getValue().getTrimmedText() : "");
            for (XmlAttribute attribute : tag.getAttributes()) {
                this.visitXmlElement((XmlElement)attribute, stub, 0);
            }
            HashMap<String, Integer> indices = new HashMap<String, Integer>();
            for (XmlTag subTag : tag.getSubTags()) {
                String name = subTag.getName();
                Integer i = (Integer)indices.get(name);
                i = i == null ? 0 : i + 1;
                this.visitXmlElement((XmlElement)subTag, stub, i);
                indices.put(name, i);
            }
        } else if (element instanceof XmlAttribute) {
            new AttributeStub(parent, ((XmlAttribute)element).getLocalName(), StringUtil.notNullize((String)nsKey), StringUtil.notNullize((String)((XmlAttribute)element).getValue()));
        }
    }
}

