/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FlatteningIterator;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiftShorterItemsClassifier
extends Classifier<LookupElement> {
    private final TreeSet<String> mySortedStrings = new TreeSet();
    private final MultiMap<String, LookupElement> myElements = LiftShorterItemsClassifier.createMultiMap(false);
    private final MultiMap<LookupElement, LookupElement> myToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final MultiMap<LookupElement, LookupElement> myReversedToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final LiftingCondition myCondition;
    private final boolean myLiftBefore;
    private int myCount = 0;

    public LiftShorterItemsClassifier(String name, Classifier<LookupElement> next, LiftingCondition condition, boolean liftBefore) {
        super(next, name);
        this.myCondition = condition;
        this.myLiftBefore = liftBefore;
    }

    @Override
    public void addElement(@NotNull LookupElement added, @NotNull ProcessingContext context) {
        if (added == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(1);
        }
        ++this.myCount;
        for (String string : CompletionUtil.iterateLookupStrings(added)) {
            if (string.length() == 0) continue;
            this.myElements.putValue((Object)string, (Object)added);
            this.mySortedStrings.add(string);
            NavigableSet<String> after2 = this.mySortedStrings.tailSet(string, false);
            for (String s : after2) {
                if (!s.startsWith(string)) break;
                for (LookupElement longer : this.myElements.get((Object)s)) {
                    this.updateLongerItem(added, longer);
                }
            }
        }
        super.addElement(added, context);
        this.calculateToLift(added);
    }

    private void updateLongerItem(LookupElement shorter, LookupElement longer) {
        if (this.myCondition.shouldLift(shorter, longer)) {
            this.myToLift.putValue((Object)longer, (Object)shorter);
            this.myReversedToLift.putValue((Object)shorter, (Object)longer);
        }
    }

    private void calculateToLift(LookupElement element2) {
        for (String string : CompletionUtil.iterateLookupStrings(element2)) {
            for (int len = 1; len < string.length(); ++len) {
                String prefix = string.substring(0, len);
                for (LookupElement shorterElement : this.myElements.get((Object)prefix)) {
                    if (!this.myCondition.shouldLift(shorterElement, element2)) continue;
                    this.myToLift.putValue((Object)element2, (Object)shorterElement);
                    this.myReversedToLift.putValue((Object)shorterElement, (Object)element2);
                }
            }
        }
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
        if (source == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(2);
        }
        if (context == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(3);
        }
        Iterable<LookupElement> iterable = this.liftShorterElements(source, null, context);
        if (iterable == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    private Iterable<LookupElement> liftShorterElements(Iterable<? extends LookupElement> source, @Nullable THashSet<? super LookupElement> lifted, ProcessingContext context) {
        THashSet srcSet = ContainerUtil.newIdentityTroveSet((int)(source instanceof Collection ? ((Collection)source).size() : this.myCount));
        ContainerUtil.addAll((Collection)srcSet, source);
        if (srcSet.size() < 2) {
            return this.myNext.classify(source, context);
        }
        return new LiftingIterable((Set<LookupElement>)srcSet, context, source, lifted);
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
        if (items == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(5);
        }
        if (context == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(6);
        }
        THashSet lifted = ContainerUtil.newIdentityTroveSet();
        Iterable<LookupElement> iterable = this.liftShorterElements(ContainerUtil.newArrayList(items), (THashSet<? super LookupElement>)lifted, context);
        List list2 = ContainerUtil.map(iterable, element2 -> new Pair(element2, (Object)lifted.contains(element2)));
        if (list2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public void removeElement(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
        if (element2 == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(8);
        }
        if (context == null) {
            LiftShorterItemsClassifier.$$$reportNull$$$0(9);
        }
        for (String s : CompletionUtil.iterateLookupStrings(element2)) {
            this.myElements.remove((Object)s, (Object)element2);
            if (!this.myElements.get((Object)s).isEmpty()) continue;
            this.mySortedStrings.remove(s);
        }
        LiftShorterItemsClassifier.removeFromMap(element2, this.myToLift, this.myReversedToLift);
        LiftShorterItemsClassifier.removeFromMap(element2, this.myReversedToLift, this.myToLift);
        super.removeElement(element2, context);
    }

    private static void removeFromMap(LookupElement key, MultiMap<LookupElement, LookupElement> mainMap, MultiMap<LookupElement, LookupElement> inverseMap) {
        Collection removed = mainMap.remove((Object)key);
        if (removed == null) {
            return;
        }
        for (LookupElement reference2 : new ArrayList(removed)) {
            inverseMap.remove((Object)reference2, (Object)key);
        }
    }

    @NotNull
    private static <K, V> MultiMap<K, V> createMultiMap(final boolean identityKeys) {
        return new MultiMap<K, V>(){

            @NotNull
            protected Map<K, Collection<V>> createMap() {
                if (identityKeys) {
                    IdentityHashMap identityHashMap = ContainerUtil.newIdentityHashMap();
                    if (identityHashMap == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return identityHashMap;
                }
                return new THashMap();
            }

            public boolean remove(K key, V value2) {
                List elements2 = (List)this.get(key);
                int i = ContainerUtil.indexOfIdentity((List)elements2, value2);
                if (i >= 0) {
                    elements2.remove(i);
                    if (elements2.isEmpty()) {
                        this.remove(key);
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier$1", "createMap"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/LiftShorterItemsClassifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSortingWeights";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LiftingIterable
    implements Iterable<LookupElement> {
        private final Set<LookupElement> mySrcSet;
        private final ProcessingContext myContext;
        private final Iterable<? extends LookupElement> mySource;
        private final THashSet<? super LookupElement> myLifted;

        LiftingIterable(Set<LookupElement> srcSet, ProcessingContext context, Iterable<? extends LookupElement> source, THashSet<? super LookupElement> lifted) {
            this.mySrcSet = srcSet;
            this.myContext = context;
            this.mySource = source;
            this.myLifted = lifted;
        }

        @Override
        public Iterator<LookupElement> iterator() {
            THashSet processed2 = ContainerUtil.newIdentityTroveSet((int)this.mySrcSet.size());
            THashSet arraysProcessed = ContainerUtil.newIdentityTroveSet();
            Iterable<? extends LookupElement> next = LiftShorterItemsClassifier.this.myNext.classify(this.mySource, this.myContext);
            Iterator base = FilteringIterator.create(next.iterator(), arg_0 -> LiftingIterable.lambda$iterator$0((Set)processed2, arg_0));
            return new FlatteningIterator<LookupElement, LookupElement>(base, (Set)arraysProcessed, (Set)processed2){
                final /* synthetic */ Set val$arraysProcessed;
                final /* synthetic */ Set val$processed;
                {
                    this.val$arraysProcessed = set;
                    this.val$processed = set2;
                    super(x0);
                }

                protected Iterator<LookupElement> createValueIterator(LookupElement element2) {
                    List<LookupElement> shorter = this.addShorterElements(LiftShorterItemsClassifier.this.myToLift.get((Object)element2));
                    List<LookupElement> singleton = Collections.singletonList(element2);
                    if (shorter != null) {
                        if (LiftingIterable.this.myLifted != null) {
                            LiftingIterable.this.myLifted.addAll(shorter);
                        }
                        Iterable<LookupElement> lifted = LiftShorterItemsClassifier.this.myNext.classify(shorter, LiftingIterable.this.myContext);
                        return (LiftShorterItemsClassifier.this.myLiftBefore ? ContainerUtil.concat(lifted, singleton) : ContainerUtil.concat(singleton, lifted)).iterator();
                    }
                    return singleton.iterator();
                }

                @Nullable
                private List<LookupElement> addShorterElements(@Nullable Collection<LookupElement> from) {
                    ArrayList<LookupElement> toLift = null;
                    if (from == null) {
                        return null;
                    }
                    if (this.val$arraysProcessed.add(from)) {
                        for (LookupElement shorterElement : from) {
                            if (!LiftingIterable.this.mySrcSet.contains(shorterElement) || !this.val$processed.add(shorterElement)) continue;
                            if (toLift == null) {
                                toLift = new ArrayList<LookupElement>();
                            }
                            toLift.add(shorterElement);
                        }
                    }
                    return toLift;
                }
            };
        }

        private static /* synthetic */ boolean lambda$iterator$0(Set processed2, LookupElement element2) {
            return processed2.add(element2);
        }
    }

    public static class LiftingCondition {
        public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
            return true;
        }
    }
}

