/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.util.io.DigestUtil;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;

public class EncryptionUtil {
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final String ENCRYPT_KEY_ALGORITHM = "AES/CBC/NoPadding";
    private static final String ENCRYPT_DATA_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int SECRET_KEY_SIZE = 128;
    public static final int SECRET_KEY_SIZE_BYTES = 16;
    private static final IvParameterSpec CBC_SALT_DATA = new IvParameterSpec(new byte[]{119, 111, -93, 2, -43, -12, 117, 82, 12, 40, 69, -34, 78, 86, -97, 95});
    private static final IvParameterSpec CBC_SALT_KEY = new IvParameterSpec(new byte[]{-84, 125, 61, 61, 95, -34, -112, -9, 7, 25, -42, 96, 11, 89, -101, -70});

    private EncryptionUtil() {
    }

    public static byte[] rawKey(@NotNull CredentialAttributes attributes) {
        if (attributes == null) {
            EncryptionUtil.$$$reportNull$$$0(0);
        }
        return EncryptionUtil.hash(new byte[][]{EncryptionUtil.getUTF8Bytes(attributes.getServiceName() + "/" + attributes.getUserName())});
    }

    public static byte[] genKey(byte[] keyBytes) {
        byte[] key = new byte[16];
        for (int i = 0; i < keyBytes.length; ++i) {
            int n = i % 16;
            key[n] = (byte)(key[n] ^ keyBytes[i]);
        }
        return key;
    }

    public static byte @NotNull [] encryptKey(byte @NotNull [] password, byte[] rawKey) {
        byte[] byArray;
        if (password == null) {
            EncryptionUtil.$$$reportNull$$$0(1);
        }
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_KEY_ALGORITHM);
            c.init(1, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_KEY);
            byArray = c.doFinal(rawKey);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        if (byArray == null) {
            EncryptionUtil.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    static byte[] encryptData(byte[] password, int size, byte[] data2) {
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_DATA_ALGORITHM);
            c.init(1, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_DATA);
            c.update(new byte[]{(byte)(size >> 24), (byte)(size >> 16), (byte)(size >> 8), (byte)size});
            return c.doFinal(data2);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES/CBC/PKCS5Padding is not available", e);
        }
    }

    public static byte[] encryptText(byte[] password, @NotNull OneTimeString value2) {
        if (value2 == null) {
            EncryptionUtil.$$$reportNull$$$0(3);
        }
        byte[] data2 = value2.toByteArray(false);
        return EncryptionUtil.encryptData(password, data2.length, data2);
    }

    static byte[] decryptData(byte[] password, byte[] encryptedData) {
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_DATA_ALGORITHM);
            c.init(2, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_DATA);
            return c.doFinal(encryptedData);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES/CBC/PKCS5Padding is not available", e);
        }
    }

    @NotNull
    public static OneTimeString decryptText(byte[] password, byte[] data2) {
        byte[] plain = EncryptionUtil.decryptData(password, data2);
        int len = ((plain[0] & 0xFF) << 24) + ((plain[1] & 0xFF) << 16) + ((plain[2] & 0xFF) << 8) + (plain[3] & 0xFF);
        if (len < 0 || len > plain.length - 4) {
            throw new IllegalStateException("Unmatched password is used");
        }
        OneTimeString oneTimeString = OneTimeStringKt.OneTimeString((byte[])plain, (int)4, (int)len);
        if (oneTimeString == null) {
            EncryptionUtil.$$$reportNull$$$0(4);
        }
        return oneTimeString;
    }

    public static byte[] getUTF8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] hash(byte[] ... data2) {
        MessageDigest h = DigestUtil.sha256();
        for (byte[] d : data2) {
            h.update(d);
        }
        return h.digest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "encryptKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "decryptText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rawKey";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "encryptKey";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "encryptText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

