/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalDecorator
extends JPanel
implements Queryable,
DataProvider,
ComponentWithMnemonics {
    private final ToolWindowImpl toolWindow;
    @Nullable
    private JPanel divider;
    private final JPanel dividerAndHeader;
    private Disposable disposable;
    static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    public static final String TOGGLE_DOCK_MODE_ACTION_ID = "ToggleDockMode";
    public static final String TOGGLE_FLOATING_MODE_ACTION_ID = "ToggleFloatingMode";
    public static final String TOGGLE_SIDE_MODE_ACTION_ID = "ToggleSideMode";
    private final ToolWindowHeader header;

    InternalDecorator(final @NotNull ToolWindowImpl toolWindow, @NotNull ToolWindowContentUi contentUi, @NotNull JComponent decoratorChild) {
        if (toolWindow == null) {
            InternalDecorator.$$$reportNull$$$0(0);
        }
        if (contentUi == null) {
            InternalDecorator.$$$reportNull$$$0(1);
        }
        if (decoratorChild == null) {
            InternalDecorator.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.dividerAndHeader = new JPanel(new BorderLayout());
        this.toolWindow = toolWindow;
        this.setFocusable(false);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.header = new ToolWindowHeader(toolWindow, contentUi, () -> toolWindow.createPopupGroup(true)){

            @Override
            protected boolean isActive() {
                return toolWindow.isActive();
            }

            @Override
            protected void hideToolWindow() {
                toolWindow.getToolWindowManager().hideToolWindow(toolWindow.getId(), false);
            }
        };
        this.enableEvents(1L);
        InternalDecorator.installFocusTraversalPolicy(this, new LayoutFocusTraversalPolicy());
        this.dividerAndHeader.setOpaque(false);
        this.dividerAndHeader.add((Component)this.header, "South");
        this.add((Component)this.dividerAndHeader, "North");
        if (SystemInfo.isMac) {
            this.setBackground((Color)new JBColor((Color)Gray._200, (Color)Gray._90));
        }
        this.add((Component)decoratorChild, "Center");
        this.setBorder(new InnerPanelBorder(toolWindow));
    }

    public ActionToolbar getHeaderToolbar() {
        return this.header.getToolbar();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public String toString() {
        return this.toolWindow.getId();
    }

    @NotNull
    private JComponent initDivider() {
        if (this.divider != null) {
            JPanel jPanel = this.divider;
            if (jPanel == null) {
                InternalDecorator.$$$reportNull$$$0(3);
            }
            return jPanel;
        }
        JPanel jPanel = this.divider = new JPanel(){

            @Override
            @NotNull
            public Cursor getCursor() {
                WindowInfo info = InternalDecorator.this.toolWindow.getWindowInfo();
                boolean isVerticalCursor = info.getType() == ToolWindowType.DOCKED ? info.getAnchor().isSplitVertically() : info.getAnchor().isHorizontal();
                Cursor cursor = isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
                if (cursor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return cursor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/InternalDecorator$2", "getCursor"));
            }
        };
        if (jPanel == null) {
            InternalDecorator.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    void applyWindowInfo(@NotNull WindowInfo info) {
        FloatingDecorator floatingDecorator;
        if (info == null) {
            InternalDecorator.$$$reportNull$$$0(5);
        }
        if (info.getType() == ToolWindowType.SLIDING) {
            ToolWindowAnchor anchor2 = info.getAnchor();
            JComponent divider = this.initDivider();
            divider.invalidate();
            if (anchor2 == ToolWindowAnchor.TOP) {
                this.add((Component)divider, "South");
            } else if (anchor2 == ToolWindowAnchor.LEFT) {
                this.add((Component)divider, "East");
            } else if (anchor2 == ToolWindowAnchor.BOTTOM) {
                this.dividerAndHeader.add((Component)divider, "North");
            } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                this.add((Component)divider, "West");
            }
            divider.setPreferredSize(new Dimension(0, 0));
        } else if (this.divider != null) {
            this.divider.getParent().remove(this.divider);
            this.divider = null;
        }
        if (info.getType() == ToolWindowType.FLOATING && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(info);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            InternalDecorator.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.toolWindow;
        }
        return null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        Collection keyStrokes;
        if (condition == 1 && pressed && (keyStrokes = KeymapUtil.getKeyStrokes((ShortcutSet)ActionManager.getInstance().getAction("FocusEditor").getShortcutSet())).contains(ks)) {
            this.toolWindow.getToolWindowManager().activateEditorComponent();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setTitleActions(@NotNull @NotNull AnAction @NotNull [] actions) {
        if (actions == null) {
            InternalDecorator.$$$reportNull$$$0(7);
        }
        this.header.setAdditionalTitleActions(actions);
    }

    void setTabActions(@NotNull @NotNull AnAction @NotNull [] actions) {
        if (actions == null) {
            InternalDecorator.$$$reportNull$$$0(8);
        }
        this.header.setTabActions(actions);
    }

    @NotNull
    final ToolWindowImpl getToolWindow() {
        ToolWindowImpl toolWindowImpl = this.toolWindow;
        if (toolWindowImpl == null) {
            InternalDecorator.$$$reportNull$$$0(9);
        }
        return toolWindowImpl;
    }

    public int getHeaderHeight() {
        return this.header.getPreferredSize().height;
    }

    public void setHeaderVisible(boolean value2) {
        this.header.setVisible(value2);
    }

    public boolean isHeaderVisible() {
        return this.header.isVisible();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JPanel divider = this.divider;
        if (divider != null) {
            IdeGlassPane glassPane = (IdeGlassPane)this.getRootPane().getGlassPane();
            if (this.disposable != null) {
                Disposer.dispose((Disposable)this.disposable);
            }
            this.disposable = Disposer.newDisposable();
            ResizeOrMoveDocketToolWindowMouseListener listener2 = new ResizeOrMoveDocketToolWindowMouseListener(divider, glassPane, this);
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)listener2, this.disposable);
            glassPane.addMousePreprocessor((MouseListener)listener2, this.disposable);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposable disposable2 = this.disposable;
        if (disposable2 != null && !Disposer.isDisposed((Disposable)disposable2)) {
            this.disposable = null;
            Disposer.dispose((Disposable)disposable2);
        }
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            InternalDecorator.$$$reportNull$$$0(10);
        }
        info.put("toolWindowTitle", this.toolWindow.getTitle());
        Content selection = this.toolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info.put("toolWindowTab", selection.getTabName());
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleInternalDecorator();
        }
        return this.accessibleContext;
    }

    static void installFocusTraversalPolicy(@NotNull Container container2, @NotNull FocusTraversalPolicy policy) {
        if (container2 == null) {
            InternalDecorator.$$$reportNull$$$0(11);
        }
        if (policy == null) {
            InternalDecorator.$$$reportNull$$$0(12);
        }
        container2.setFocusCycleRoot(true);
        container2.setFocusTraversalPolicyProvider(true);
        container2.setFocusTraversalPolicy(policy);
        InternalDecorator.installDefaultFocusTraversalKeys(container2, 0);
        InternalDecorator.installDefaultFocusTraversalKeys(container2, 1);
    }

    private static void installDefaultFocusTraversalKeys(@NotNull Container container2, int id2) {
        if (container2 == null) {
            InternalDecorator.$$$reportNull$$$0(13);
        }
        container2.setFocusTraversalKeys(id2, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorChild";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/InternalDecorator";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecorator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initDivider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyWindowInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTitleActions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTabActions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installFocusTraversalPolicy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultFocusTraversalKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AccessibleInternalDecorator
    extends JPanel.AccessibleJPanel {
        private AccessibleInternalDecorator() {
            super(InternalDecorator.this);
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name == null) {
                String title = StringUtil.defaultIfEmpty((String)InternalDecorator.this.toolWindow.getTitle(), (String)InternalDecorator.this.toolWindow.getStripeTitle());
                title = StringUtil.defaultIfEmpty((String)title, (String)InternalDecorator.this.toolWindow.getId());
                name = StringUtil.notNullize((String)title) + " Tool Window";
            }
            return name;
        }
    }

    private static final class ResizeOrMoveDocketToolWindowMouseListener
    extends MouseAdapter {
        private final JComponent divider;
        private final IdeGlassPane glassPane;
        private final InternalDecorator decorator;
        private boolean isDragging;

        private ResizeOrMoveDocketToolWindowMouseListener(@NotNull JComponent divider, @NotNull IdeGlassPane glassPane, @NotNull InternalDecorator decorator) {
            if (divider == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(0);
            }
            if (glassPane == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(1);
            }
            if (decorator == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(2);
            }
            this.divider = divider;
            this.glassPane = glassPane;
            this.decorator = decorator;
        }

        private boolean isInDragZone(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(3);
            }
            Point point = new Point(e.getPoint());
            SwingUtilities.convertPointToScreen(point, e.getComponent());
            if ((this.decorator.toolWindow.getWindowInfo().getAnchor().isHorizontal() ? point.y : point.x) == 0) {
                return false;
            }
            SwingUtilities.convertPointFromScreen(point, this.divider);
            return Math.abs(this.decorator.toolWindow.getWindowInfo().getAnchor().isHorizontal() ? point.y : point.x) < 6;
        }

        private void updateCursor(@NotNull MouseEvent event, boolean isInDragZone) {
            if (event == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(4);
            }
            if (isInDragZone) {
                this.glassPane.setCursor(this.divider.getCursor(), (Object)this.divider);
                event.consume();
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(5);
            }
            this.isDragging = this.isInDragZone(e);
            this.updateCursor(e, this.isDragging);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(6);
            }
            this.updateCursor(e, this.isInDragZone(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(7);
            }
            this.updateCursor(e, this.isInDragZone(e));
            this.isDragging = false;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(8);
            }
            this.updateCursor(e, this.isDragging || this.isInDragZone(e));
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                ResizeOrMoveDocketToolWindowMouseListener.$$$reportNull$$$0(9);
            }
            if (!this.isDragging) {
                return;
            }
            ToolWindowAnchor anchor2 = this.decorator.toolWindow.getAnchor();
            Container windowPane = this.decorator.getParent();
            Point lastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), windowPane);
            lastPoint.x = Math.min(Math.max(lastPoint.x, 0), windowPane.getWidth());
            lastPoint.y = Math.min(Math.max(lastPoint.y, 0), windowPane.getHeight());
            Rectangle bounds2 = this.decorator.getBounds();
            if (anchor2 == ToolWindowAnchor.TOP) {
                this.decorator.setBounds(0, 0, bounds2.width, lastPoint.y);
            } else if (anchor2 == ToolWindowAnchor.LEFT) {
                this.decorator.setBounds(0, 0, lastPoint.x, bounds2.height);
            } else if (anchor2 == ToolWindowAnchor.BOTTOM) {
                this.decorator.setBounds(0, lastPoint.y, bounds2.width, windowPane.getHeight() - lastPoint.y);
            } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                this.decorator.setBounds(lastPoint.x, 0, windowPane.getWidth() - lastPoint.x, bounds2.height);
            }
            this.decorator.validate();
            e.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "glassPane";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecorator$ResizeOrMoveDocketToolWindowMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInDragZone";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCursor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InnerPanelBorder
    implements Border {
        @NotNull
        private final ToolWindowImpl window;

        private InnerPanelBorder(@NotNull ToolWindowImpl window) {
            if (window == null) {
                InnerPanelBorder.$$$reportNull$$$0(0);
            }
            this.window = window;
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                InnerPanelBorder.$$$reportNull$$$0(1);
            }
            if (g == null) {
                InnerPanelBorder.$$$reportNull$$$0(2);
            }
            g.setColor(JBColor.border());
            this.doPaintBorder(c, g, x, y, width, height);
        }

        private void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            Graphics2D graphics2D = (Graphics2D)g;
            if (insets.top > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + insets.top - 1), (double)(x + width - 1), (double)(y + insets.top - 1));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + insets.top), (double)(x + width - 1), (double)(y + insets.top));
            }
            if (insets.left > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)y, (double)x, (double)(y + height));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + 1), (double)y, (double)(x + 1), (double)(y + height));
            }
            if (insets.right > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + width - 1), (double)(y + insets.top), (double)(x + width - 1), (double)(y + height));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)(x + width), (double)(y + insets.top), (double)(x + width), (double)(y + height));
            }
            if (insets.bottom > 0) {
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + height - 1), (double)(x + width), (double)(y + height - 1));
                LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)(y + height), (double)(x + width), (double)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            if (c == null) {
                InnerPanelBorder.$$$reportNull$$$0(3);
            }
            ToolWindowManagerImpl toolWindowManager = this.window.getToolWindowManager();
            WindowInfo windowInfo = this.window.getWindowInfo();
            if (toolWindowManager.getProject().isDisposed() || !toolWindowManager.isToolWindowRegistered(this.window.getId()) || windowInfo.getType() == ToolWindowType.FLOATING || windowInfo.getType() == ToolWindowType.WINDOWED) {
                return JBUI.emptyInsets();
            }
            ToolWindowAnchor anchor2 = windowInfo.getAnchor();
            Container component2 = this.window.getComponent();
            Container parent = component2.getParent();
            boolean isSplitter = false;
            boolean isFirstInSplitter = false;
            boolean isVerticalSplitter = false;
            while (parent != null) {
                if (parent instanceof Splitter) {
                    Splitter splitter = (Splitter)parent;
                    isSplitter = true;
                    isFirstInSplitter = splitter.getFirstComponent() == component2;
                    isVerticalSplitter = splitter.isVertical();
                    break;
                }
                component2 = parent;
                parent = component2.getParent();
            }
            int top = isSplitter && (anchor2 == ToolWindowAnchor.RIGHT || anchor2 == ToolWindowAnchor.LEFT) && windowInfo.isSplit() && isVerticalSplitter ? -1 : 0;
            int left = anchor2 == ToolWindowAnchor.RIGHT && (!isSplitter || isVerticalSplitter || isFirstInSplitter) ? 1 : 0;
            int bottom = 0;
            int right = anchor2 == ToolWindowAnchor.LEFT && (!isSplitter || isVerticalSplitter || !isFirstInSplitter) ? 1 : 0;
            return new Insets(top, left, bottom, right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/InternalDecorator$InnerPanelBorder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBorder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBorderInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

