/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDownloaderImpl
implements FileDownloader {
    private static final Logger LOG = Logger.getInstance(FileDownloaderImpl.class);
    private static final String LIB_SCHEMA = "lib://";
    private final List<? extends DownloadableFileDescription> myFileDescriptions;
    private final JComponent myParentComponent;
    @Nullable
    private final Project myProject;
    private String myDirectoryForDownloadedFilesPath;
    private final String myDialogTitle;

    public FileDownloaderImpl(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project, @Nullable JComponent parentComponent, @NotNull String presentableDownloadName) {
        if (fileDescriptions == null) {
            FileDownloaderImpl.$$$reportNull$$$0(0);
        }
        if (presentableDownloadName == null) {
            FileDownloaderImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileDescriptions = fileDescriptions;
        this.myParentComponent = parentComponent;
        this.myDialogTitle = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)presentableDownloadName)});
    }

    @Nullable
    public List<VirtualFile> downloadFilesWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        List<Pair<VirtualFile, DownloadableFileDescription>> pairs = this.downloadWithProgress(targetDirectoryPath, project, parentComponent);
        if (pairs == null) {
            return null;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, DownloadableFileDescription> pair : pairs) {
            files2.add((VirtualFile)pair.getFirst());
        }
        return files2;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProgress(@Nullable String targetDirectoryPath, @Nullable Project project, @Nullable JComponent parentComponent) {
        File dir;
        if (targetDirectoryPath != null) {
            dir = new File(targetDirectoryPath);
        } else {
            VirtualFile virtualDir = FileDownloaderImpl.chooseDirectoryForFiles(project, parentComponent);
            if (virtualDir != null) {
                dir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir);
            } else {
                return null;
            }
        }
        return this.downloadWithProcess(dir, project, parentComponent);
    }

    @Nullable
    private List<Pair<VirtualFile, DownloadableFileDescription>> downloadWithProcess(File targetDir, Project project, JComponent parentComponent) {
        Ref localFiles = Ref.create(null);
        Ref exceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                localFiles.set(this.download(targetDir));
            }
            catch (IOException e) {
                exceptionRef.set((Object)e);
            }
        }, this.myDialogTitle, true, project, parentComponent);
        if (!completed) {
            return null;
        }
        Exception exception = (Exception)exceptionRef.get();
        if (exception != null) {
            boolean tryAgain = IOExceptionDialog.showErrorDialog((String)this.myDialogTitle, (String)exception.getMessage());
            if (tryAgain) {
                return this.downloadWithProcess(targetDir, project, parentComponent);
            }
            return null;
        }
        return FileDownloaderImpl.findVirtualFiles((List)localFiles.get());
    }

    @NotNull
    public List<Pair<File, DownloadableFileDescription>> download(@NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileDescription>> arrayList;
        if (targetDir == null) {
            FileDownloaderImpl.$$$reportNull$$$0(2);
        }
        List<Pair<File, DownloadableFileDescription>> downloadedFiles = Collections.synchronizedList(new ArrayList());
        List existingFiles = Collections.synchronizedList(new ArrayList());
        ProgressIndicator parentIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (parentIndicator == null) {
            parentIndicator = new EmptyProgressIndicator();
        }
        try {
            ConcurrentTasksProgressManager progressManager = new ConcurrentTasksProgressManager(parentIndicator, this.myFileDescriptions.size());
            parentIndicator.setText(IdeBundle.message((String)"progress.downloading.0.files.text", (Object[])new Object[]{this.myFileDescriptions.size()}));
            int maxParallelDownloads = Runtime.getRuntime().availableProcessors();
            LOG.debug("Downloading " + this.myFileDescriptions.size() + " files using " + maxParallelDownloads + " threads");
            long start2 = System.currentTimeMillis();
            ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileDownloaderImpl Pool", (int)maxParallelDownloads);
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileDescription downloadableFileDescription : this.myFileDescriptions) {
                results.add(executor.submit(() -> {
                    SubTaskProgressIndicator indicator = progressManager.createSubTaskIndicator();
                    indicator.checkCanceled();
                    File existing = new File(targetDir, description.getDefaultFileName());
                    String url = description.getDownloadUrl();
                    if (url.startsWith(LIB_SCHEMA)) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)LIB_SCHEMA));
                        File file2 = PathManager.findFileInLibDirectory((String)path);
                        existingFiles.add(Pair.create((Object)file2, (Object)description));
                    } else if (url.startsWith("file://")) {
                        String path = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)url, (String)"file://"));
                        File file3 = new File(path);
                        if (file3.exists()) {
                            existingFiles.add(Pair.create((Object)file3, (Object)description));
                        }
                    } else {
                        File downloaded;
                        try {
                            downloaded = FileDownloaderImpl.downloadFile(description, existing, indicator);
                        }
                        catch (IOException e) {
                            throw new IOException(IdeBundle.message((String)"error.file.download.failed", (Object[])new Object[]{description.getDownloadUrl(), e.getMessage()}), e);
                        }
                        if (FileUtil.filesEqual((File)downloaded, (File)existing)) {
                            existingFiles.add(Pair.create((Object)existing, (Object)description));
                        } else {
                            totalSize.addAndGet(downloaded.length());
                            downloadedFiles.add(Pair.create((Object)downloaded, (Object)description));
                        }
                    }
                    indicator.finished();
                    return null;
                }));
            }
            for (Future future2 : results) {
                try {
                    future2.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)e.getCause();
                    }
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start2;
            LOG.debug("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms)");
            ArrayList<Pair<File, DownloadableFileDescription>> localFiles = new ArrayList<Pair<File, DownloadableFileDescription>>();
            localFiles.addAll(FileDownloaderImpl.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            FileDownloaderImpl.deleteFiles(downloadedFiles);
            throw e;
        }
        if (arrayList == null) {
            FileDownloaderImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile chooseDirectoryForFiles(Project project, JComponent parentComponent) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(IdeBundle.message((String)"dialog.directory.for.downloaded.files.title", (Object[])new Object[0])).withDescription(IdeBundle.message((String)"dialog.directory.for.downloaded.files.description", (Object[])new Object[0]));
        VirtualFile baseDir = project != null ? project.getBaseDir() : null;
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)parentComponent, (Project)project, (VirtualFile)baseDir);
    }

    private static List<Pair<File, DownloadableFileDescription>> moveToDir(List<Pair<File, DownloadableFileDescription>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileDescription>> result2 = new ArrayList<Pair<File, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
            DownloadableFileDescription description = (DownloadableFileDescription)pair.getSecond();
            String fileName = description.generateFileName(s -> !new File(targetDir, (String)s).exists());
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result2.add((Pair<File, DownloadableFileDescription>)Pair.create((Object)toFile, (Object)description));
        }
        return result2;
    }

    @NotNull
    private static List<Pair<VirtualFile, DownloadableFileDescription>> findVirtualFiles(List<Pair<File, DownloadableFileDescription>> ioFiles) {
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> result2 = new ArrayList<Pair<VirtualFile, DownloadableFileDescription>>();
        for (Pair<File, DownloadableFileDescription> pair : ioFiles) {
            File ioFile = (File)pair.getFirst();
            VirtualFile libraryRootFile = (VirtualFile)WriteAction.computeAndWait(() -> {
                String url = VfsUtil.getUrlForLibraryRoot((File)ioFile);
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
                return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
            });
            if (libraryRootFile == null) continue;
            result2.add((Pair<VirtualFile, DownloadableFileDescription>)Pair.create((Object)libraryRootFile, (Object)pair.getSecond()));
        }
        ArrayList<Pair<VirtualFile, DownloadableFileDescription>> arrayList = result2;
        if (arrayList == null) {
            FileDownloaderImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void deleteFiles(List<Pair<File, DownloadableFileDescription>> pairs) {
        for (Pair<File, DownloadableFileDescription> pair : pairs) {
            FileUtil.delete((File)((File)pair.getFirst()));
        }
    }

    @NotNull
    private static File downloadFile(final @NotNull DownloadableFileDescription description, final @NotNull File existingFile, final @NotNull ProgressIndicator indicator) throws IOException {
        if (description == null) {
            FileDownloaderImpl.$$$reportNull$$$0(5);
        }
        if (existingFile == null) {
            FileDownloaderImpl.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            FileDownloaderImpl.$$$reportNull$$$0(7);
        }
        final String presentableUrl = description.getPresentableDownloadUrl();
        indicator.setText2(IdeBundle.message((String)"progress.connecting.to.download.file.text", (Object[])new Object[]{presentableUrl}));
        indicator.setIndeterminate(true);
        File file2 = (File)HttpRequests.request((String)description.getDownloadUrl()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request2) throws IOException {
                if (request2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                int size = request2.getConnection().getContentLength();
                if (existingFile.exists() && (long)size == existingFile.length()) {
                    return existingFile;
                }
                indicator.setText2(IdeBundle.message((String)"progress.download.file.text", (Object[])new Object[]{description.getPresentableFileName(), presentableUrl}));
                return request2.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp"), indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/util/download/impl/FileDownloaderImpl$1", "process"));
            }
        });
        if (file2 == null) {
            FileDownloaderImpl.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public FileDownloader toDirectory(@NotNull String directoryForDownloadedFilesPath) {
        if (directoryForDownloadedFilesPath == null) {
            FileDownloaderImpl.$$$reportNull$$$0(9);
        }
        this.myDirectoryForDownloadedFilesPath = directoryForDownloadedFilesPath;
        FileDownloaderImpl fileDownloaderImpl = this;
        if (fileDownloaderImpl == null) {
            FileDownloaderImpl.$$$reportNull$$$0(10);
        }
        return fileDownloaderImpl;
    }

    public VirtualFile @Nullable [] download() {
        List<VirtualFile> files2 = this.downloadFilesWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
        return files2 != null ? VfsUtilCore.toVirtualFileArray(files2) : null;
    }

    @Nullable
    public List<Pair<VirtualFile, DownloadableFileDescription>> downloadAndReturnWithDescriptions() {
        return this.downloadWithProgress(this.myDirectoryForDownloadedFilesPath, this.myProject, this.myParentComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDescriptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableDownloadName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/download/impl/FileDownloaderImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryForDownloadedFilesPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/download/impl/FileDownloaderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SubTaskProgressIndicator
    extends SensitiveProgressWrapper {
        private final AtomicDouble myFraction;
        private final ConcurrentTasksProgressManager myProgressManager;

        private SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager) {
            super(progressManager.myParent);
            this.myProgressManager = progressManager;
            this.myFraction = new AtomicDouble();
        }

        @Override
        public void setFraction(double newValue) {
            double oldValue = this.myFraction.getAndSet(newValue);
            this.myProgressManager.updateFraction(newValue - oldValue);
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            if (this.myProgressManager.myTasksCount > 1) {
                return;
            }
            super.setIndeterminate(indeterminate);
        }

        @Override
        public void setText2(String text2) {
            this.myProgressManager.setText2(this, text2);
        }

        @Override
        public double getFraction() {
            return this.myFraction.get();
        }

        public void finished() {
            this.setFraction(1.0);
            this.myProgressManager.setText2(this, null);
        }
    }

    private static class ConcurrentTasksProgressManager {
        private final ProgressIndicator myParent;
        private final int myTasksCount;
        private final AtomicDouble myTotalFraction;
        private final Object myLock = new Object();
        private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();

        private ConcurrentTasksProgressManager(ProgressIndicator parent, int tasksCount) {
            this.myParent = parent;
            this.myTasksCount = tasksCount;
            this.myTotalFraction = new AtomicDouble();
        }

        public void updateFraction(double delta) {
            this.myTotalFraction.addAndGet(delta / (double)this.myTasksCount);
            this.myParent.setFraction(this.myTotalFraction.get());
        }

        public SubTaskProgressIndicator createSubTaskIndicator() {
            return new SubTaskProgressIndicator(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text2) {
            if (subTask == null) {
                ConcurrentTasksProgressManager.$$$reportNull$$$0(0);
            }
            if (text2 != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.put((Object)subTask, (Object)text2);
                }
                this.myParent.setText2(text2);
            } else {
                String prev;
                Object object = this.myLock;
                synchronized (object) {
                    this.myText2Stack.remove((Object)subTask);
                    prev = (String)this.myText2Stack.getLastValue();
                }
                if (prev != null) {
                    this.myParent.setText2(prev);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subTask", "com/intellij/util/download/impl/FileDownloaderImpl$ConcurrentTasksProgressManager", "setText2"));
        }
    }
}

