/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerState;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements PersistentStateComponent<XDebuggerState> {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Debugger messages", (String)"Debug", (boolean)false);
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final XDebuggerPinToTopManager myPinToTopManager;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final AtomicReference<XDebugSessionImpl> myActiveSession;
    private XDebuggerState myState;
    private static final TooltipGroup RUN_TO_CURSOR_TOOLTIP_GROUP = new TooltipGroup("RUN_TO_CURSOR_TOOLTIP_GROUP", 0);

    public XDebuggerManagerImpl(@NotNull Project project) {
        if (project == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(0);
        }
        this.mySessions = Collections.synchronizedMap(new LinkedHashMap());
        this.myActiveSession = new AtomicReference();
        this.myState = new XDebuggerState();
        this.myProject = project;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this);
        this.myWatchesManager = new XDebuggerWatchesManager();
        this.myPinToTopManager = new XDebuggerPinToTopManager();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(3);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileContentLoaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileContentReloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$2";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(breakpoint instanceof XLineBreakpoint) && (session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session2.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (breakpoint == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint == session2.getActiveNonLineBreakpoint()) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "breakpoint";
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor2 != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor2.getProcessHandler());
                    if (session2 != null) {
                        session2.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setCurrentSession(null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (descriptor2 != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor2.getProcessHandler());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "executor";
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void checkUnloadPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                XDebugSession[] sessions;
                if (pluginDescriptor == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (XDebugSession session2 : sessions = XDebuggerManagerImpl.this.getDebugSessions()) {
                    XDebugProcess process2 = session2.getDebugProcess();
                    if (!process2.dependsOnPlugin(pluginDescriptor)) continue;
                    throw new CannotUnloadPluginException("Plugin is not unload-safe because of the started debug session");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$5", "checkUnloadPlugin"));
            }
        });
        DebuggerEditorListener listener2 = new DebuggerEditorListener();
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)listener2, (Disposable)this.myProject);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)listener2, (Disposable)this.myProject);
    }

    public void initializeComponent() {
        this.myBreakpointManager.init();
    }

    private void updateExecutionPoint(@NotNull VirtualFile file2, boolean navigate2) {
        if (file2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(1);
        }
        if (file2.equals(this.myExecutionPointHighlighter.getCurrentFile())) {
            this.myExecutionPointHighlighter.update(navigate2);
        }
    }

    void updateExecutionPoint(GutterIconRenderer renderer) {
        this.myExecutionPointHighlighter.updateGutterIcon(renderer);
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        XBreakpointManagerImpl xBreakpointManagerImpl = this.myBreakpointManager;
        if (xBreakpointManagerImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(2);
        }
        return xBreakpointManagerImpl;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    @NotNull
    public XDebuggerPinToTopManager getPinToTopManager() {
        XDebuggerPinToTopManager xDebuggerPinToTopManager = this.myPinToTopManager;
        if (xDebuggerPinToTopManager == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(3);
        }
        return xDebuggerPinToTopManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        if (environment == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(4);
        }
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(5);
        }
        XDebugSessionImpl xDebugSessionImpl = this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
        if (xDebugSessionImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(6);
        }
        return xDebugSessionImpl;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(7);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(8);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, contentToReuse, false, starter2);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(9);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(10);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(11);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter2);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(12);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon2, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(13);
        }
        if (starter2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(14);
        }
        XDebugSessionImpl session2 = this.startSession(contentToReuse, starter2, new XDebugSessionImpl(null, this, sessionName, icon2, showToolWindowOnSuspendOnly, contentToReuse));
        if (!showToolWindowOnSuspendOnly) {
            session2.showSessionTab();
        }
        ProcessHandler handler2 = session2.getDebugProcess().getProcessHandler();
        handler2.startNotify();
        XDebugSessionImpl xDebugSessionImpl = session2;
        if (xDebugSessionImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(15);
        }
        return xDebugSessionImpl;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session2) throws ExecutionException {
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(16);
        }
        if (session2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(17);
        }
        XDebugProcess process2 = processStarter.start((XDebugSession)session2);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process2);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session2.activateSession();
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session2.getSessionData());
        }
        session2.init(process2, contentToReuse);
        this.mySessions.put(session2.getDebugProcess().getProcessHandler(), session2);
        return session2;
    }

    void removeSession(@NotNull XDebugSessionImpl session2) {
        if (session2 == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(18);
        }
        XDebugSessionTab sessionTab = session2.getSessionTab();
        this.mySessions.remove(session2.getDebugProcess().getProcessHandler());
        if (sessionTab != null && !this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
            RunContentManager.getInstance((Project)this.myProject).hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), sessionTab.getRunContentDescriptor());
        }
        if (this.myActiveSession.compareAndSet(session2, null)) {
            this.onActiveSessionChanged(session2, null);
        }
    }

    void updateExecutionPoint(@Nullable XSourcePosition position, boolean nonTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, nonTopFrame, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
        ApplicationManager.getApplication().invokeLater(() -> {
            ValueLookupManager.getInstance(this.myProject).hideHint();
            DebuggerUIUtil.repaintCurrentEditor(this.myProject);
        }, this.myProject.getDisposed());
        if (!this.myProject.isDisposed()) {
            ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).currentSessionChanged(previousSession, currentSession);
        }
    }

    public XDebugSession @NotNull [] getDebugSessions() {
        XDebugSession[] xDebugSessionArray = this.mySessions.values().toArray(new XDebugSessionImpl[0]);
        if (xDebugSessionArray == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(19);
        }
        return xDebugSessionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(20);
        }
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        synchronized (map2) {
            for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
                RunContentDescriptor contentDescriptor;
                XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
                if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
                return debuggerSession;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        // MONITORENTER : map2
        List list2 = StreamEx.of(this.mySessions.values()).map(XDebugSessionImpl::getDebugProcess).select(processClass).toList();
        // MONITOREXIT : map2
        if (list2 != null) return list2;
        XDebuggerManagerImpl.$$$reportNull$$$0(21);
        return list2;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession.get();
    }

    void setCurrentSession(@Nullable XDebugSessionImpl session2) {
        boolean sessionChanged;
        XDebugSessionImpl previousSession = this.myActiveSession.getAndSet(session2);
        boolean bl = sessionChanged = previousSession != session2;
        if (sessionChanged) {
            if (session2 != null) {
                XDebugSessionTab tab = session2.getSessionTab();
                if (tab != null) {
                    tab.select();
                }
            } else {
                this.myExecutionPointHighlighter.hide();
            }
            this.onActiveSessionChanged(previousSession, session2);
        }
    }

    public XDebuggerState getState() {
        XDebuggerState state = this.myState;
        this.myBreakpointManager.saveState(state.getBreakpointManagerState());
        this.myWatchesManager.saveState(state.getWatchesManagerState());
        this.myPinToTopManager.saveState(state.getPinToTopManagerState());
        return state;
    }

    public boolean isFullLineHighlighter() {
        return this.myExecutionPointHighlighter.isFullLineHighlighter();
    }

    public void loadState(@NotNull XDebuggerState state) {
        if (state == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(22);
        }
        this.myState = state;
        this.myBreakpointManager.loadState(state.getBreakpointManagerState());
        this.myWatchesManager.loadState(state.getWatchesManagerState());
        this.myPinToTopManager.loadState(state.getPinToTopManagerState());
    }

    public void noStateLoaded() {
        this.myBreakpointManager.noStateLoaded();
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processStarter";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinToTopManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startSession";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "startSessionAndShowTab";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugSessions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcesses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateExecutionPoint";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 21: {
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startSession";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startSessionAndShowTab";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeSession";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDebugSession";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DebuggerEditorListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        RangeHighlighter myCurrentHighlighter;

        private DebuggerEditorListener() {
        }

        boolean isEnabled(@NotNull EditorMouseEvent e) {
            if (e == null) {
                DebuggerEditorListener.$$$reportNull$$$0(0);
            }
            Editor editor = e.getEditor();
            if (e.getArea() != EditorMouseEventArea.LINE_NUMBERS_AREA || editor.getProject() != XDebuggerManagerImpl.this.myProject || !EditorUtil.isRealFileEditor(editor) || !XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isRunToCursorGestureEnabled()) {
                return false;
            }
            XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
            return session2 != null && session2.isPaused() && !session2.isReadOnly();
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                DebuggerEditorListener.$$$reportNull$$$0(1);
            }
            if (!this.isEnabled(e)) {
                this.removeHighlighter(e);
                return;
            }
            this.removeHighlighter(e);
            int lineNumber = this.getLineNumber(e);
            if (lineNumber < 0) {
                return;
            }
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES);
            Editor editor = e.getEditor();
            this.myCurrentHighlighter = editor.getMarkupModel().addLineHighlighter(lineNumber, 5999, attributes);
            HintHint hint = new HintHint(e.getMouseEvent()).setAwtTooltip(true).setPreferredPosition(Balloon.Position.above);
            String text2 = UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor"));
            TooltipController.getInstance().showTooltipByMouseMove(editor, new RelativePoint(e.getMouseEvent()), new LineTooltipRenderer(text2, new Object[]{text2}), false, RUN_TO_CURSOR_TOOLTIP_GROUP, hint);
            IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(Cursor.getPredefinedCursor(12), (Object)this);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                DebuggerEditorListener.$$$reportNull$$$0(2);
            }
            this.removeHighlighter(e);
        }

        private void removeHighlighter(@NotNull EditorMouseEvent e) {
            if (e == null) {
                DebuggerEditorListener.$$$reportNull$$$0(3);
            }
            if (this.myCurrentHighlighter != null) {
                this.myCurrentHighlighter.dispose();
                TooltipController.getInstance().cancelTooltip(RUN_TO_CURSOR_TOOLTIP_GROUP, e.getMouseEvent(), true);
                IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(null, (Object)this);
                this.myCurrentHighlighter = null;
            }
        }

        private int getLineNumber(EditorMouseEvent event) {
            Editor editor = event.getEditor();
            int line = editor.yToVisualLine(event.getMouseEvent().getY());
            if (line >= ((EditorImpl)editor).getVisibleLineCount()) {
                return -1;
            }
            int offset = ((EditorImpl)editor).visualLineStartOffset(line);
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
            return editor.getDocument().getLineNumber(lineStartOffset);
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e == null) {
                DebuggerEditorListener.$$$reportNull$$$0(4);
            }
            if (e.getMouseEvent().getButton() == 1 && this.isEnabled(e)) {
                int lineNumber = this.getLineNumber(e);
                XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
                if (session2 != null && lineNumber >= 0) {
                    session2.runToPosition(XSourcePositionImpl.create(((EditorEx)e.getEditor()).getVirtualFile(), lineNumber), false);
                    e.consume();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$DebuggerEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeHighlighter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

